/*******************************************************************************
* Project:      Amped'RF Wifi
* File name:    Custom.h
* Author:       
* Created:      07/12/2016
* Description:  Settings and definitions unique to customizations
*
* Copyright (c) 2016 Amped'RF Inc. All rights reserved.
*******************************************************************************/

#ifndef CUSTOM_H
#define CUSTOM_H


//------------------------------------------------------------------------------
// Customization setting -- Choose Only One or none
//------------------------------------------------------------------------------
//#define CUSTOM_HART

//------------------------------------------------------------------------------
//   Customer    S E T T I N G S
//------------------------------------------------------------------------------

//-------------------------------------------------------------------------
// CUSTOM_HART Settings
//-------------------------------------------------------------------------
#ifdef CUSTOM_HART
#define DEVICE_NAME 	   "HART WiFi Modem"
#define TX_EN              1
#define OCD				   2
#define RTS_Data_Delay 	   1
#define RTS_Hold_Delay 	   10
#define HART_Link_Quiet_Timer "380"
#define DEFAULT_MAIN_PARITY         "odd"      // 0=none, 1=odd
#endif


//==========================================================================================================
//================                   General Default Settings                               ================
//==========================================================================================================

#ifndef DEVICE_NAME
#define DEVICE_NAME 	   "Amped WiFi"
#endif

#ifdef DEBUG_CONFIG_DEFAULT
#define DHCP_MODE        "true"                 // var04
#define IP_ADDRESS       "192.168.1.2"          // var05
#define IP_GATEWAY       "192.168.1.1"          // var07
#define SSID_NAME      	 "NETGEAR85"            // var08
#define PASSPHRASE       "hungrytree018"        // var09
#define AUTHTYPE     	 "1"                    // var10
#define HOST_IP_ADDR     "192.168.1.3"          // var11
#define IPPROTOCOL		 "0"                    // var12
#define DEVICE_MODE      "0"                    // var28

#elif defined(HOSTAPD)//1
#define DHCP_MODE        "true"                 // var04
#define IP_ADDRESS       "192.168.1.2"          // var05
#define IP_GATEWAY       "192.168.1.1"          // var07
#define SSID_NAME      	 "Amped RF"             // var08
#define PASSPHRASE       "12345678"             // var09
//#define AUTHTYPE     	 "0"                    // var10
#define HOST_IP_ADDR     "192.168.1.3"          // var11
#define DEVICE_MODE      "STA"                  // var28 - bcolias changed from AP
#define CHANNEL_AP     	 "6"//"149"
#endif


#define CONFIG_VARS_VERSION "4.2"

#define TM_DEVICE_NAME              ((char *)TM_GetFlashReadPtr(VAR_ID_DeviceName))

#define SAE             "2"
#define WPAPSK          "1"
#define WPANONE         "0"

#ifndef MAC_ADDRESS
#define MAC_ADDRESS      "00043e26002d"
#define MAC_AP_ADDRESS   "00043e26002e"
#define MAC_ADDRESS_NULL "000000000000"
#define MAC_ADDR_LEN	 6
#endif

#ifndef DHCP_MODE
#define DHCP_MODE        "true"
#endif

#ifndef IP_ADDRESS
#define IP_ADDRESS       "192.168.0.2"
#endif

#ifndef IP_NETMASK
#define IP_NETMASK       "255.255.255.0"
#endif

#ifndef IP_GATEWAY
#define IP_GATEWAY       "192.168.0.1"
#endif

#ifndef SSID_NAME
#define SSID_NAME      	 "SSID"
#endif

#ifndef PASSPHRASE
#define PASSPHRASE       "12345678"
#endif

#ifndef AUTHTYPE
#define AUTHTYPE     	 WPAPSK //"1"
#endif

#ifndef CHANNEL_AP
#define CHANNEL_AP     	    "1"
#endif

#ifndef DEVICE_MODE
#define DEVICE_MODE         "STA"
#endif

#ifndef CUSTOM_HOST_EVENTS
#define CUSTOM_HOST_EVENTS  "true"
#endif

#ifndef MAIN_BAUDRATE
#define MAIN_BAUDRATE		"115200"
#endif

#ifndef DEBUGINFO
#define DEBUGINFO			"0"
#endif
#ifndef TESTMODE
#define TESTMODE			"0"
#endif

#ifndef HOST_IP_ADDR
#define HOST_IP_ADDR		"192.168.0.3"
#endif

#ifndef IPPROTOCOL
#define IPPROTOCOL		    "UDP" //0-TCP Server, 1-UDP, 2-TCP Client
#endif

#ifndef HOST_PORT
#define HOST_PORT			"2015"
#endif

#ifndef LOCAL_PORT
#define LOCAL_PORT			"2015"
#endif

#ifndef AT_REPLY
#define AT_REPLY            "AT-WF "
#endif

#ifndef TM_LED_POSITIVE_LOGIC
#define TM_LED_POSITIVE_LOGIC   true
#endif

#ifndef DEFAULT_MAIN_DATA_BITS
#define DEFAULT_MAIN_DATA_BITS      "8"         // 7p, 8, 8p. 8w, 9
#endif
#ifndef DEFAULT_MAIN_PARITY
#define DEFAULT_MAIN_PARITY         "none"      // 0=none, 1=odd
#endif
#ifndef DEFAULT_MAIN_STOP_BITS
#define DEFAULT_MAIN_STOP_BITS      "1"         // .5, 1, 1.5, 2
#endif
#ifndef CUSTOM_UART_TIMEOUT
#define CUSTOM_UART_TIMEOUT         "16"        // Uart char timeout
#endif
#ifndef CUSTOM_UART_FLOW_CTRL
#define CUSTOM_UART_FLOW_CTRL       "false"
#endif

#ifndef OUT_MTU_SIZE
#ifdef ENB_BYPASS
#define OUT_MTU_SIZE       	     "1024"//"1000"
#else
#define OUT_MTU_SIZE       	     "400"
#endif
#endif

#ifndef CUSTOM_MAX_STACOUNT
#define CUSTOM_MAX_STACOUNT       	"14"
#endif

#ifndef MULTIPOINT_DEFAULT
#define MULTIPOINT_DEFAULT       	"0"
#endif

#ifndef CUSTOM_EXTLPO
#define CUSTOM_EXTLPO       			"false"
#endif

#ifndef CUSTOM_SHALLOW_SLEEP_ENABLE
#define CUSTOM_SHALLOW_SLEEP_ENABLE       			"false"
#endif

#ifndef HOST_DEEP_SLEEP
#define HOST_DEEP_SLEEP       			"false"
#endif
#define HOST_SHALLOW_SLEEP_BIT	0x01
#define HOST_DEEP_SLEEP_BIT		0x02

#ifndef C_AP_MAX_INACTIVITY
#define C_AP_MAX_INACTIVITY				"120"
#endif

#ifndef AUDIOMODE_DEFAULT
#define AUDIOMODE_DEFAULT       	"1"  // 0-DLNA; 1-Airplay
#endif

//Robert add for MESH
#ifndef MESH_SSID_NAME
#define MESH_SSID_NAME      	 "mymesh12345"
#endif

#ifndef MESH_PASSPHRASE
#define MESH_PASSPHRASE          "12345678"
#endif

#ifndef MESH_AUTHTYPE
#define MESH_AUTHTYPE     	     SAE //"3"
#endif

/******************************************
*             MEDIA_STREAMING             *
*******************************************/
#if defined(AIRPLAY) || defined(DLNA_ENABLE)
//#define MEDIA_STREAMING
#endif

/******************************************
*             __HARDWARE__                *
*******************************************/
#if defined(BOARD_WF41)
#define __HARDWARE__            "WF41"
#elif defined(BOARD_WF43S)
#if defined(BOARD_WF52)
#define __HARDWARE__            "WF52"
#elif defined(BOARD_WF43)
#define __HARDWARE__            "WF43"
#elif defined(BOARD_WF88M)
#define __HARDWARE__            "WF88-M"
#endif
#elif defined(BOARD_WB42_DEV)
#define __HARDWARE__            "WB42_DEV"
#else
#warning Hardware Not Defined
#endif

/******************************************
*             CUSTOM_CPU_MHZ              *
*******************************************/
#ifdef MEDIA_STREAMING
#define CUSTOM_CPU_MHZ          "168"
#else
#define CUSTOM_CPU_MHZ          "200"
#endif

/******************************************
*             __OPTION__                  *
*******************************************/
#if    defined(AIRPLAY)
#define __OPTION__  "_AIRPLAY"
#elif  defined(MEDIA_STREAMING)
#define __OPTION__  "_MEDIA"
#endif

/******************************************
*             CUSTOM_HARDWARE             *
*******************************************/
#ifdef __OPTION__
#define CUSTOM_HARDWARE         __HARDWARE__ __OPTION__
#else
#define CUSTOM_HARDWARE         __HARDWARE__
#endif

#ifndef WSM_FIRMWARE
#define WSM_FIRMWARE "wsm_V3.2.3.bin"
#endif

#ifndef WSM_BOOTLOADER
#define WSM_BOOTLOADER "bootloader.bin"
#endif

#ifndef WSM_SDD
#define WSM_SDD "sdd_6010.bin"
#endif

/******************************************
*            CUSTOM_AUDIO_CTRL            *
*******************************************/
//#if defined(RADIO_DECODER) || defined(AVS)
#define SRC_BUF_SIZE    	"8"
#define SRC_BUF_LOWER    	"2"
#define SRC_BUF_UPPER    	"2"
#define PCM_BUF_SIZE    	"8"
#define PCM_BUF_LOWER    	"2"
#define PCM_BUF_UPPER    	"2"
#define HOST_ADDRESS    	"http://smartspeakerdemo.ampedrftech.com"
#define CONFIG_PATH			"controller_a"
#define PLAYLIST_PATH   	"playlist_a"
#define MEDIA_PATH      	"music_a"
#define	CONFIG_NAME     	"music_control.txt"
#define PLAYLIST_NAME   	"default.txt"
#define VOL_DEFAULT     	"6"
//#endif

//#if defined(AVS)
#define REC_MST_VOL         "80"
#define REC_PGA_VOL         "60"
#define REC_TIM_THR         "30"
//#endif
//add end

//Robert add for Feature List
//#define LWIPERF
//#define AUDIO_APP
#ifdef AUDIO_APP
#include "audio_app.h"
#define ENABLE_WavePlayer
#define	AUDIO_WAVE_FILE  	"outer_limits.wav"
#endif

//#define MQTT_CLIENT
#ifdef MQTT_CLIENT
#include "at_cmd_mqtt.h"
//Robert add for MQTT config
#define MQTT_SIP            "91.121.93.94"
#define MQTT_SPORT          "1883"
#define MQTT_USRNAME        "admin"
#define MQTT_PW             "password"
#define MQTT_SUBC           "SToC"
#define MQTT_PUBH           "CToS"
#define MQTT_QoS            "0"
#define MQTT_AUTH           "1"
#define LOCAL_IP6           "FE80::204:3EFF:FE26:2A"
#define REMOTE_IP6          "FE80::204:3EFF:FE26:2A"
#define ADDR_TYPE           "0"
#define WORKMODE            "0"

#define	MQTT_CA_CRT_FILE  	"ca.crt"
#define	MQTT_CLI_CRT_FILE  	"client.crt"
#define	MQTT_CLI_KEY_FILE  	"client.key"

#define URL_DNS1_V4         "8.8.8.8"
#define URL_DNS1_V6         "2001:4860:4860::8888"
#define URL_DNS2_V4         "1.1.1.1"
#define URL_DNS2_V6         "2606:4700:4700::1111"
#endif
#define	APP_AUTO_START  	"false"

//#define HTTPS_CLIENT
#ifdef HTTPS_CLIENT
#include "at_cmd_http.h"
#define HTTPS_CLIENT_CA_CRT_FILE  "gtsrootR1.crt"
#endif

//#define FIREBASE_CLIENT
#ifdef FIREBASE_CLIENT
#include "at_cmd_fb.h"
#define FB_CONFIG_JSON_FILE  "my-test-project-148ba.json"
#define	FB_DEV_REG_FLAG  	"false"
//#define FB_DEV_REG_TOKEN     "epaC0sKiunsx9zl2uwOT2R:APA91bHbpi3z1sFkcIRFw-w5lNeamM-7QKSBTCPakc9e1tfu54-55UpuGPLDSfhufcjRN8VQ1QfDBxBz2uVOyWxdAe9OQ1pNrcrNSPOZVjUO0dkLa9jfkmo"
#define DEFAULT_TZONE        "8"
#define	NTP_SERVER_NAME      "pool.ntp.org"
#endif

#endif // CUSTOM_H
//------------------------------------------------------------------------------

