/*******************************************************************************
* Project:      Amped'RF Bluetooth
* File name:    coprocessor.h
* Author:       Tony
* Created:      12/10/2010
* Description:  iPod Authentication Coprocessor 2.0B Specification
*
* Copyright (c) 2010 Amped'RF Inc. All rights reserved.
*******************************************************************************/

//NOTE: CP is a chip, iPod Authentication Coprocessor

#ifndef __COPROCESSOR_H
#define __COPROCESSOR_H

#include "AT_Common.h"

#if (0)
    #define PRINT_I2C_DATA
#endif

#define DEVICE_ID_LENGTH                      4     //Device ID

#define ACC_CERTIFICATE_DATA_LENGTH           2   //Accessory Certificate Data Length
#define ACC_CER_DATA_PAGESIZE                 128   //Accessory Certificate Data Page Size
#define ACC_CER_DATA_COUNTER                  2
#define ACC_CER_DATA_SIZE                     (ACC_CER_DATA_PAGESIZE * ACC_CER_DATA_COUNTER)  //make a large packet 
                                                                           //authentication will faster.

typedef enum eCP_Register{

  //Block 0
  eCP_DeviceVersion                         =0x00,
  eCP_FirmwareVersion                       =0x01,
  eCP_AuthenticationProtocolMajorVersion    =0x02,
  eCP_AuthenticationProtocolMinorVersion    =0x03,
  eCP_DeviceID                              =0x04,
  eCP_ErrorCode                             =0x05,

  //Block 1
  eCP_AuthenticationControlStatus           =0x10,
  eCP_SignatureDataLength                   =0x11,
  eCP_SignatureData                         =0x12,

  //Block 2
  eCP_ChallengeDataLength                   =0x20,
  eCP_ChallengeData                         =0x21,


  //Block 3
  eCP_AccessoryCertificateDataLength        =0x30,
  eCP_AccessoryCertificateDataPage1         =0x31,
  eCP_AccessoryCertificateDataPage2         =0x32,
  eCP_AccessoryCertificateDataPage3         =0x33,
  eCP_AccessoryCertificateDataPage4         =0x34,
  eCP_AccessoryCertificateDataPage5         =0x35,
  eCP_AccessoryCertificateDataPage6         =0x36,
  eCP_AccessoryCertificateDataPage7         =0x37,
  eCP_AccessoryCertificateDataPage8         =0x38,
  eCP_AccessoryCertificateDataPage9         =0x39,
  eCP_AccessoryCertificateDataPage10        =0x3A,
  eCP_AccessoryCertificateDataPage11        =0x3B,
  eCP_AccessoryCertificateDataPage12        =0x3C,
  eCP_AccessoryCertificateDataPage13        =0x3D,
  eCP_AccessoryCertificateDataPage14        =0x3E,
  eCP_AccessoryCertificateDataPage15        =0x3F,

  //Block 4

  eCP_SelftestControlStatus                 =0x40,

  //Block 5
  eCP_iPodCertificateDataLength             =0x50,
  eCP_iPodCertificateDataPage1              =0x51,
  eCP_iPodCertificateDataPage2              =0x52,
  eCP_iPodCertificateDataPage3              =0x53,
  eCP_iPodCertificateDataPage4              =0x54,
  eCP_iPodCertificateDataPage5              =0x55,
  eCP_iPodCertificateDataPage6              =0x56,
  eCP_iPodCertificateDataPage7              =0x57,
  eCP_iPodCertificateDataPage8              =0x58,

}eCP_Register;

typedef enum eCP_EventType{
  eCP_Event_RetDevAuthentiactionInfo=0,
  eCP_Event_SetFIDTokenValues=1,
  eCP_Event_RetDevAuthentiactionSignature=2,





}eCP_EventType;


typedef struct RetDevAutInfoStruct{
  uint8 AuthenticationMajorVersion;
  uint8 AuthenticationMinorVersion;
  uint8 CurrentSection;
  uint8 MaximumSection;
  uint8 CertificatetDataBuf[ACC_CER_DATA_SIZE];
  uint16 CertificatetDataBufLength;
  //uint16 RetDevAutInfoStructSize;

} RetDevAutInfoStruct;

#define IS_CP_EVENT_TYPE(TYPE) (((TYPE) == eCP_Event_RetDevAuthentiactionInfo) || \
                                ((TYPE) == eCP_Event_RetDevAuthentiactionSignature) || \
                                ((TYPE) == eCP_Event_SetFIDTokenValues))
                                //((TYPE) == eCP_Event_DivceID) || \
                                //((TYPE) == eCP_Event_DivceID))







uint8  GetAccCerDataPackCnt(void);
uint16 GetCerDataLength(void);
void SendChallengeData(uint8 *pDataBuf,uint16 length);//AC Send data to CP

void iPodAuthenticatesAccessory(uint8 EventType,uint16 StartDataLength,uint16 EndDataLength,uint8 **ppBuff,uint16 *pDataLength);
//void iPodAuthenticatesAccessory(uint8 EventType,uint16 StartDataLength,uint16 EndDataLength,uint8 **ppBuff,uint16 *pDataLength,
//                                uint8 *pChallengeData,uint16 Challengelength);

void Init_CP_I2C(void);












#endif
