/*******************************************************************************
* Project:      Amped'RF WIFI
* File name:    build_version.h
* Author:       Grace
* Created:      05/20/2014
* Description:  Contains the build version. Change this for each release build
*
* Copyright (c) 2014 Amped'RF Inc. All rights reserved.
********************************************************************************/
#ifndef BUILD_VERSION_H
#define BUILD_VERSION_H
/*******************************************************************************
*140915A 1. Based on the version 140714A of WB242.
         2. In this version the MCU using F401 and CW1200 interface using SPI.
         3. Change the architecture of project more clear.
         4. Change SSID from "tom" to "Amp'ed_AP".
*141009A
         1. Add IAR project WF43S.
         2. Undefine CUSTOM_USE_SPI, fixed some functions about it.
         3. Fixed functions TM_GetStoredMACAddr(), solved the macaddress changing issue after factoryinit.
         4. Add some AT commands about GPIO, to control, write and read GPIO.
*141016B 1. Uart Rx DMA added.
*141020A Merged WF41 & WF43S sources to one baseline
*141021A Merged with Airplay
*141030A 1.CW1200 SPI using DMA send and recv.
         2.change the code architecture of audio playing.
		 3.optimize the receive process of wifi stack.
*===============================================================================
*141022A 1. Uart Tx DMA added.
*        2. printu() now uses Tx DMA.
*141028B 1. Added OSClock timer as a general purpose count-up clock.
*        2. Added AT Status command for debugging.
*        3. Added RX_CHARS_LIMIT to be used to throttle the UART flow.
*        4. Added Hardware config variable.
*        5. Added AT_ProcessHostDataInBypass() back for bypass state data flow.
*        6. Added GKI_uart_FlowControl() and GKI_uart_ReceiveEnable() for flow control.
*141028C Initialize UART pins at startup to avoid hangs.
*150106A Added DEBUG_REPORT_ENABLE
*150114B Added SPI Rx DMA interrupt
*150116A Added RcvTest. Autoselects SPI prescaler to be >= 8M bps.
*150121B Added SndTest.
*        SystemCoreClock set to correct Hz.
*150122A Displays a report after a SndTest run.
*150127A Config var IPProtocol now accepts "TCP" and "UDP" as settings.
*        Bypass mode better controlled.
*150128A Default Cpu MHz to 42, Airplay 100
*        Free buffer after AT_ProcessHostDataInBypass() is called.
*        Defaults DHCP mode to true
*150202A Extracting bytes from the DMA moved from IRQ to Task context.
*150206A Uart flow control added back to tcpip_apimsg()
*150206B malloc and free references changed to os_malloc and os_free.
*150210B Add vIPSendTask() and change TCP, UDP symbols to IPTYPE_TCP/UDP.
*150211B Bytes are now extracted from the Uart DMA in ISR context.
*        Uart Flow control is added flow off when buffers are depleted.
*150211C Bug fixes in SndTest and non-FlowControl mode.
*
*150211D 1. Fixed no response for AT commands after SocketOpen, using SocketOpen
*			and SocketClose functions for TCP server on and off, add a task TCPServerTask for TCP links.
*        2. Fixed the bug printing UDP/TCP data in command mode.
*		 3. Delete TCPListen command which is useless and some other print info.
*		 4. fixed repeat scan result in realloc error, rewrite function os_realloc() .
*		 5. add message "AT-WF ScanComplete" for process of scan ended.
*		 6. define BOARD_WB42_DEV for a new circuit board, use pb6 for WIRQ,
*			so add pb6 initial code and interrupt vector, and modify port.c.
*150211E 1. Adjusted AT_MAX_HOST_DATA_LENGTH to 1412. This should help avoid many of the
*           numerous asserts found in releases 150211C/D.
*        2. Default DHCP to false.
*150211F vBufCleanupTask changed to use os_free().
*150218A Use heap_4.c which combines adjacent free blocks to limit memory fragmentation.
*150220A Add code to report the PC register on HardFaults.
*150317A 1. Seperate received buffers from DMA for music playback. DMA now uses only
*           two frames and has a separate buffer queue for received UDP buffers frames.
*        2. Removed mem_malloc and implemented --redirect for malloc library.
*150320A 1. Added Build_Options.h
*150422A 1. Added DFrameMaxTm to measure gap size.
*        2. Added AIRPLAY_HYSTERESIS
*        3. Improved airplay_playmusic() report of tracking info.
*        4. Added 10 ms delays in long printu() text such as in config displays.
*        5. Decreased CW1200_MAC_WORK_QUEUE_COUNT and CW1200_MAC_WORK_QUEUE_BUFF_SIZE.
*        6. Commented out "ludp queue send fail" msg in ieee80211_handle_udp_directly()
*        7. Changed configTOTAL_HEAP_SIZE, MEDIA_FRAME_MAX
*        8. Added GKI_rcc_i2s_Speed().
*150424A Merge with china work from 150402A
*150511A  1. Using uart TX pool as UDP/TCP receive data buffer.
               2. Adjust printu() to separate DMA process and print info .
               3. Change the judgment of starting initialize Ethernet in cw1200_init() to solve the hard fault caused by wrong passphase.
               4. Fixed cw1200_unjoin_work() to stop SSID info printed repeatedly.
               5. Delete some useless tasks to save memory.
*150520A Will.Zhang
*		1.Add AP function, add the HOSTAPD group (DHCPD, websrv).
*		  Now can run without encryption AP functions, open a simple web page.
*		  Linker: use hostapd.icf, ram(0x20000200~0x2001FFFF).
*		2.scan.numOfChannels=13,model can scan 13 channels.
*150624A Bill Colias
*       1. Renamed GKI_dma_TxDriectly() to GKI_dma_TxDirectly().
*       2. Added checks to BP_ReturnToPool() and vPortFree() to ensure pool
*          or heap memory is freed using the correct routine.
*       3. Fixed problems with RcvMsgTest() used in testing.
*150624A
*       1. Add OutMtuSize configuration, and set the value range 1-1420, default value is 1400.
*       2. Using os_malloc() to get UART DMA buffer and enlarge the configTOTAL_HEAP_SIZE.
*       3. Network connection mode increased to four patterns: 0 TCP server, 1 udp server, 2 TCP client, 3 udp client.
*       4. Receive packet but abandon it when there is no UART TX pool.
*       5. Add a judgment about the pointer to avoid the memory free error in ieee80211_probe_auth_done() and ieee80211_assoc_done();
*150630A
*       Added a new folder/group httpserver to serve up web pages for AP.
*150630B
*       Fixed problem with DeviceMode config variable
*150630C
*       Added AP-STA to DeviceMode
*150630E
*		1.	Add some AT commands to show memory information, network and connections.
*		2.	Add dropped data number in status command.
*		3.  Add AP host event.
*
*======================================================================================================
*
*150630G
*       1. Added SysTimer pool memory.
*       2. Reduced CW1200_MAC_WORK_QUEUE_COUNT & LUDP_RX_QUEUE_COUNT.
*150630H
*       Test for heap memory in BP_ReturnToPool().
*150630I
*       1. Add new project "WB42_AP_AirPlay", so Airplay can work in AP or STA mode, run on wb42_dev board.
*       2. Add macro define AP_AIRPLAY, so POOLNUM, MEDIA_FRAME_MAX and configTOTAL_HEAP_SIZE be control.
*		3. Add cw1200_set_udplist_filter(hw, portlist, portnum) in airplay_audio() filter 3 ports,
*		   so dhcp can work.
150630J
*       1. Add new project "WF41_AP_AirPlay", so Airplay can work in AP or STA mode, run on WF41 board.
*150723A
*       1. Change some configuration default value and print massages.
*		2. Moudle connection mode reduced to three patterns: 0 TCP server, 1 UDP, 2 TCP client.
*       3. Fix cw1200 "firmware assert" issue by controlling the tx buffer credit
*       4. Give xCw1200TxSemaphore after cw1200_data_write. This will avoid writing SKB buffer before pervious data sending out.
*       5. Hold on data transfer before receiving Arp reply.
*       6. Fix a hardfault issue from TxInfoInvalid.
*       7. The group HAL->STM32F4xx's compiler optimizations must be set low to avoid join failure.
*150723B
    1. Config var for DeviceMode now shows text (STA, AP, AP-STA).
    2. Config var for IPProtocol now shows text (UDP, TCP, TCP-UDP).
    3. Added DEBUG_MEM_ALLOCATIONS for tracking mallocs.
    4. Setup MEMP_PBUF_POOL to use pool memory.
*150723C
    1. Project set to use IAR 7.2
    2. Symbol WF41 replaced with BOARD_WF41.
    3. AIRPLAY for CUSTOM_HARDWARE defined first to avoid incorrect symbol assignments.

*150904A
    1. Added in Tasks.c a warning when a task cannot be created.
    2. Turned on internal memory pool options for lwip
    3. Adjusted values in lwipopts.h and FreeRTOSConfig.h
    4. Added GKI_queue to a create circular record queue to replace MacReceiveBuff. The files
       affected are macrx.c and ethernetif.c.
    5. Changed the ShowPool command to show heap pools and lwip pools.
    6. Added ShowFS command to show file system info contained in the http server.
    7. Reduced file sizes in the http server.

*150917B
    1. Decreased stack depth in SndTest task from 512 to 200.
    2. Added TM_DmaRxCountPeek().
    3. Increased Uart TXPOOLSIZE from 1480 to 1500.
    4. Changed Uart POOLNUM from 6 to 4 for Rx, and 7 for Tx.
    5. Added httpd_config.c/h.
    6. Added extended pool info controlled by EXTEND_POOL_INFO
    7. Decreased MEMP_NUM_TCP_PCB from 12 to 6
    8. Increased PBUF_POOL_SIZE from 6 to 10
    9. Decreased PBUF_POOL_BUFSIZE from 256 to 212
    10. Decreased MACRX_DATAMAX from 3000 to 2000.
    11. Increased in work.c WorkBuff size from 1700 to 1800.
    12. Added ResetModule().
    13. Added Auto Start code controlled by AUTOSTART_ENABLE
    14. Increased configTOTAL_HEAP_SIZE from 52 to 53.
    15. Added DEBUG_CHAR_TRAP to dump pool info during screen lockups.

*150917C
    1. Increased Uart TXPOOLSIZE from 1500 to 1504.

*150917D
    1. Changed TXPOOLSIZE to 1500, but changed pool creation for Tx to account
       for the extra tLinkTxBuff (6 bytes) at the beginning of the buffer.

*151007B
    AP_AIRPLAY removed. Always assume AP_AIRPLAY functionality when AIRPLAY is used.
    Merge of two baselines (David & Bill)
    DLPA_ENABLE added to control DLNA code compilation.

*151007C
    Replaced ecRxBuff with macrxQ. macrxc, macqueue.h, and ethernetif.c effected.

*151007D
    1. Test code remove from ieee80211_handle_udp_directly() in macrx.c.
    2. ATReply variable made hidden.
    3. OutMtuSize variable changed from 1500 to 150.
    4. Check on bootup for driver existence added.
    5. #pragma optimize level=low added to EXTI3_IRQHandler() and EXTI9_5_IRQHandler()
       so that the rest of the STM32F4xx library can be compiled on high optimization.

*151007E
    1. PBUF size changed to 256, num changed to 48.

*151016A
    1. Some Debug prints added/changed in DLNA code.

*151023A
    1. Dynamically allocate heap memory for malloc to all available ram.

*151202A
    1.	SDIO_BLOCK_SIZE value set to 64.
    2.	Ignore ARP flag and no delay in do_send() in AP mode.
    3.	Add a AP judgment in eloop_run() for the hard fault after scan many times.
    4.	TCP_SEND_QUEUELEN value set to 50.
    5.	Set socket option TCP_NODELAY to improve the TCP sending packet rates and data speed.
    6.	Add multiple connection of UDP in AP mode and TCP server for multiple clients.
    7.	Add unjoin command to disconnect an exsit STA's connection with AP.
    8.	Modify join command, format is at+ab join [ssid] [passphrase].
        If no passphrase means AP is none encryption;
        If no ssid and passphrase means use config information in flash.
    9.	Add two the AT command for  enable/disable SSID broadcast
    10.	Modify client wait for FIN timeout, from 20 seconds to 2 seconds
    11.	Solve the problem that "Module in STA mode is not reliable to join our own module in AP mode"
    12. Give different PBUF num to DLNA/Airplay and other projects.
    13. AT_cmd.c on medium optimization to avoid hard fault when module STA join module AP.
*151214A
	1.	Add memory check for vPortFree, if memory leak, print and stop.
	2.  Add option->link->extra options: "--redirect printf=printu".
    3.  Combine two BEACON commands together.
    4.  Add the function that STA reset CW1200 when AP far away from STA

*151214B
	1.	Recover using TxCredit for low data transfer speed issue in UDP/TCP.
    2.  Delete the useless semaphore xMAC_recv_lock.
	3.	Improve the STA device info storage algorithm, solve the showdev bug and mistake in multiple connections.
	4.	Adjust some Macros value in Lwipopts.h for improving TCP data transfer speed.
	5.	Change the usage of xCw1200TxSemaphore for TCP sending blocked issue.
	6.	Recover high optimization of AT_cmd.c.
	7.	Set TCP_NODELAY with big UART packets, default more than 700 bytes is a big packet.
	8.	Modify the beacon lose counter from 60 to 20.
	9.	SCANJOIN,and UNJOIN can't be used in AP mode.
	10.	skb->next and skb->prev initialized to NULL
	11.	WF43S STA is set unjoin state,when HTC328 (a phone AP) close.
	12.	put acAp and sacPsk(two variable) into structural body.
    13.	Fixed IP address error in showdevice_cb().

*151214C
    1.  Do not reset module on os_malloc() failure.

*151214D
    1.  Changed SndTest to use pool memory to mimic buffer use when UART is used.
    2.  Altered SndTest to report pause time.

*151214E
    1. WF_printu() added.
    2. tScan_Type added.
    3. cqm_link_loss_count changed from 20 to 60.

*151214F
    bh.c and hwio.c optimization changed from Low to None in WF43S.

*151214G
    1. Optimizations changes from 151214F reversed.
    2. TCP_SND_BUF changed from 3000 to 3200.
    3. TCP_MSS changed to 1000.
    4. Created tcp_flowready() to check if tcp is ready to send.
    5. vIPSendTask checks if send was successful, releases buffer if not.
    6. lwip_send() checks tcp_flowready().
    7. pool buffer routines changed to track memory (see POOL_MEM_TRACKING).
    8. In tcp_receive() use BP_MemTrackReturn() to return buffers when sufficient
       bytes are ACKed as sent (see POOL_MEM_TRACKING).
    9. TCP_SNDLOWAT changed from TCP_SND_BUF)/2 to 50.

*151214H
	1. Disable some debug macro and debug info
	2. Fixed UDP pool release error.

*151214L
    Added taskENTER_CRITICAL() and taskEXIT_CRITICAL() to pool.c and TM_UartHandler.c

*151214N
    1. Recoded SndTest to use pool memory.
    2. Turned of Nagle algorithm by setting BIGPACKET to 1.
    3. Added CW1200_BH_RESEND_MSGID to cw1200_bh().
    4. Added Critical Code protection to SPI_ReadBytes(), SPI_SendBytes(),
       cw1200_spi_memcpy_fromio().
    5. Added defines for cw1200_tx_h_rate_policy().
    6. Added code in cw1200_tx_confirm_cb() to requeue sending a packet on
       WSM_STATUS_RETRY_EXCEEDED by sending CW1200_BH_RESEND_MSGID.
    7. Added __wsm_get_status_text() to return WSM status.
    8. Increased TCP_SND_BUF from 3200 to 8200.
    9. Added DbgTrace() for debugging.

*151214P
	1. Changed PBUF_POOL_SIZE for Airplay and DLNA functions.
	2. Made some changes in project option for Airplay and DLNA compiling and output.
	3. Disable the BSS-Lost event indications in DLNA.
	4. Set SDIO_BLOCK_SIZE to 16 for DLNA.

*160311A - Based on 151214N
    1. Removed POOL_MEM_TRACKING code.
    2. Added 200 byte margin to TM_UART_MAIN_RX_DMA_SIZE.
    3. Added defines CW1200_CQM_LINK_LOSS_COUNT and CW1200_CQM_BEACON_LOSS_COUNT
    4. Changed TCP_TMR_INTERVAL from 250 to 100 ms
    5. Recoded UartHandler.c to exclusively handle UART RTS logic.
    6. Removed RTS handling logic from AT_Cmd.c and netbuf.c

*160312A
    Merged of 151214P and 160311A

*160312B
    1. Decreased TCP_SND_BUF from 8200 to 3200.
    2. Increased MACRX_DATAMAX from 2000 to 3000.
    3. Critical code sections put back into pool.c.

*160312C
    1. Removed sock_flowready() check from vIPSendTask().
    2. Increased margin in Rx DMA from 200 to 400 bytes.
    3. Removed tcp_flowready() check from lwip_send().
    4. Increased speed of SPI to typically 21M.
    5. Increased default CPU speed from 42 to 84 MHz.

*160312D
    1. Temporarily increased priority within tcpip_apimsg() to make sure the
       semaphore is not released by a higher priority task before it is set.

*160312C2
    1. (Merge from ver D)Temporarily increased priority within tcpip_apimsg() to make sure the
         semaphore is not released by a higher priority task before it is set.
    2. Change the DLNA data fetch method.
    3. Fixed the critical section code.
    4. Add debug info when DLNA play.

*160312E
    1. Use PCLK2 instead of PCLK1 for computing and displaying SPI1 speed.
    2. Added task_priorities.h to define all task priorities.

*160312F
    1. Replaced ENTER_CRITICAL with portENTER_CRITICAL.
    2. Improved RcvTest to handle Nagle.

*160312G
	1. Adjust some configurations for DLNA to promote audio quality.
	2. Make sure enter and exit critical section functions really do something.

*160312H
	1. Reversed changes to enter and exit critical section functions.
    2. Changed excessively high ISR priorities to configLIBRARY_MAX_SYSCALL_INTERRUPT_PRIORITY.

*160312I
    1. Added compile time option USE_ACC in fwio.h for better management of drivers.
    2. Added section for AIRPLAY in fwio.h. Assumes ACC drivers is 0x80000 higher in FLASH.
    3. Altered WSM size reference to use temporary bin file for 1340.
    4. Changed DRIVERS NOT FOUND check to use addresses from fwio.h.
    5. Increased SRAM memory size 0x40000.
    6. AIRPLAY assumes larger memory of STM32F429.
    7. Heap4.c assumes memory of 0x30000 size for AIRPLAY.
    8. Increased AIRPLAY buffers from 18 to 60.

*160312J
    1. Use Streaming.FrameLowWM instead of Streaming.FrameTarget to determine when
       start the I2S DMA.
    2. Remove code within AIRPLAY_HYSTERESIS and use a new routine GKI_i2s_SpeedAdjustment()
       within Streaming_FeedDMA() to make i2s speed adjustments. Do a running average
       and use result to send a message to i2s_AdjTask() which does the speed calculation
       for i2s.

*160312K
    1. Obsoleted the airplay_playmusic() task used to monitor and track the playback rates.
    2. Added i2s_AdjTask() to adjust the speed of i2s and also call AirShowStats() to
       monitor and track the playback rates.
    3. Added PID code, but is disabled. This may be of use in the future.
    4. Instead of sending zeros to the i2s DMA when packets aren't received fast enough,
       the last packet is used instead. This makes the missing packets less noticable when
       playing music.
    5. Size reference of the wsm file changed for version wsm 1.0 in fwio.h.
    6. Period removed from "Unjoin" message.
    7. Added dma_print() to make use of the USART DMA when sending messages.
    8. Added USE_CCM_RAM as a preprocessor define to utilize the 64K CCM memory with
       Airplay's media buffer.
    9. Volume defaults to low on startup.
   10. I2S speed adjustment has a new algorithm. It uses a running average to compute how
       many media packets are queued for each time the I2S consumes a packet. It then
       uses that average to determine how far it is for the target level. It uses that
       measurement and the slope to determine whether to add or subtract to the I2S speed.
       When a stable speed is determined, that value is saved for future startups.
   11. Valid range of i2s speeds was expanded. This value can be found and changed by the
       new at+ab N command.

*160312M
    1. Config CpuMHz error response repaired.
    2. Use cw1200 when WF43 is used.
    3. New algorithm for Airplay impememted--
        a. Running average computed over 1.6 secs
        b. Make corrections after each period (8 secs).
        c. Inband correction if slope over two periods is greater than 10.
        d. Out of Band correction when on initial entry into that band.
        e. After the 3rd period in Out of Band, make a correction using a three period slope.
*======================================================================================================
*160312N
	1. Add PowerSave mode.
		add new group 'WF43_ACC', this is base on new WF43 moudle, stm32f411 + ACC1340.
		add 'VAR_ID_HostShallowSleepEnable' and 'VAR_ID_HostDeepSleepEnable' to configration.
		add 'USE_PS_MODE' and 'USE_ACC' in new group.
		add function 'vApplicationIdleHook()' in AT_Cmd.c, and modify 'hconfigUSE_IDLE_HOOK' to 1
		add 'GKI_LP_ClockConfig(32768)' in 'prvSetupHardware()', is use to generate a 32kHz for wifichip.
		notice function 'cw1200_device_wakeup()', need to read more times:
			cw1200_reg_read_16(priv, ST90TDS_CONTROL_REG_ID, &ctrl_reg);
	2. commited 'wpa_config_update_psk' in 'wpa_supplicant_init_iface()'.
*160312O
	1. Remove conditional judgment, '#ifdef USE_PS_MODE' in bh.c, line 283.
*160312P
	1. Add Count to prevent program infinite loop in vUartTask(), wait for g_RunningState = CW1200_RUNNING_STATUS_INITOK.
	2. Add AT command "showversion", to display hardware, app version, wsm version, sdd version, bootloader size.
*160312Q
	1. Repair AP mode, link inactivity timeout. Get nullfunc from STA, to judge STA status.
	2. Repair STA mode, At a distance, join failure, ever.Use low tx rate(assoc, auth frames) and clear some flags  to avoid reconnection failure.
	3. Repair unjoin command, clear flag and save eth_int task.
	4. Modify UART idle interrupt use mode.
*160312R
    1. Improved ShowCpu to handle F429 correctly.
    2. Increased CpuMhz for F429 to go up to 180 MHz.
    3. Increased FLASH latency for CPU MHz above 100.
    4. In CW1200_LowLevel_Init(), Limited SPI baudrate to 21MHz.
    5. Decreased POOLNUM for Rx from 4 to 2 to improve robustness in high throughput operation.
*160718A
    1. Add WF52 project based on WF43_ACC project.
    2. Update the configuration version number to 4.0.
    3. Fixed USE_PS_MODE bug in prvSetupHardware().
    4. Add notify in ieee80211_rx_h_sta_process(), when data transmit.
    5. Fixed bug when use tim_last .
*160718B
	1.	Give xCw1200TxSemaphore in cw1200_tx_confirm_cb() instead of in cw1200_bh().
	2.	Add packet ID check and resend times in cw1200_tx_confirm_cb()
	3.	Add TCP sanity check, change some value of LWIP and TCP settings to optimize IP layer capability.
	4.	Change OutMtuSize value and add rate calculation in sndtest command.
	5.	Add macro define judgment HOSTAPD for call ap_h_timer(). 
	6.	Change the max value of length from 1500 to 1514 in low_level_output().
	7.	Delete the ARP reply delay in do_send().
	8.	SPI using DMA and polling mode, SPI rate increased to 42M.
*160718C
  1.	Adjust some buffer malloc and free operations to avoid memory leak in join and unjoin operation.
  2.	Set OUT_MTU_SIZE to 1000 to avoid slow TCP sending rate in Sndtest command.
  3.	Fix some bugs in Sndtest command.
  4.	Change some tx retry policy parameters to keep data send successfully.
  5.	Add UPLAYER_RESEND to control packet resend in up layer.
  6.	Resume the PBUF_POOL_SIZE and MEM_SIZE of LWIP like before version for saving memory, and disable TCP sanity check.  
*160718D
	1. Fix join fail in ieee80211_scan_rx()
*160718E
	1.Fix AP mode inactive station timeout.
	2.Fix local_wk mem release when join and unjoin.There are 40 bytes of leaks that are not resolved.
*160718F
	1. Airplay with external crystal
	2. Add "AudioMode" configuration for the airplay/DLNA
	3. Add STM32F429_439xx and DLNA_ENABLE defined symbols into WF41_AP_Airplay project
	4. The icf file change to WF41V2_DLNA+Airplay.icf, in order to support STM32F429
	5. Add SDD,WSM and bootloader into WF41_AP_Airplay project. 
	6. Set the default CPU rate to 168MHz, in order to improve the audio qulity.
	7. Configuration is V4.1.
	8. "StationInactive" configuration be limited in 15~255.
*160718G
	1. add autojoin function
    2. add custom.h file
*170323A
	1. move all config parameters to custom.h file
    2. when auto join fail four times, do not reset, just do nothing
	3. config gpio[5] as led to indicate auto join connected or not 
    4. solve the hardfault issue (when input at+wf config, but do not input CR/LF, then autojoin enter bypass mode, 
	   now input Escape, then the chip meet hardfault and reset)	
********************************************************************************/


//----------------------------
// Modify build version here
//----------------------------
#define __BUILD__   "170926A"


//--------------------------------------------------------
#define BUILD_VERSION   __BUILD__
//--------------------------------------------------------
//--------------------------------------------------------

#endif // BUILD_VERSION_H

