//------------------------------------------------------------------------------
//
//
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
//  Includes
//
//------------------------------------------------------------------------------
#ifndef UTILITIES_H
#define UTILITIES_H

#include "AT_Common.h"
#include "AT_Config.h"

//------------------------------------------------------------------------------
//
//  Conastants
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
//  Defines
//
//------------------------------------------------------------------------------
#define TM_TICKS_PER_SECOND         (20000)     // Cortex RTC
#define TM_TICKS_PER_MILLISECOND    (TM_TICKS_PER_SECOND/1000)
#define TM_MS_TICKS                 TM_TICKS_PER_MILLISECOND

//------------------------------------------------------------------------------
//
//  Macros
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
//  Global Variables
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
// Local Variables
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
//  Local Functions
//
//------------------------------------------------------------------------------
inline bool VALID_BAUD(uint32 baudrate) {
    switch (baudrate) {
    case 300:
    case 1200:
    case 2400:
    case 4800:
    case 9600:
    case 19200:
    case 38400:
    case 57600:
    case 115200:
    case 230400:
    case 460800:
    case 921600:
    case 1000000:
    case 2000000:
    case 2250000:
        return (bool)(true);
    default:
        return (bool)(false);
   }
}

//------------------------------------------------------------------------------
//
//  Global funnctions
//
//------------------------------------------------------------------------------
void UT_SkipBlanks(char **p);
#ifdef FCC
u8 UT_FindBlank(char **p);//by cbq 20241024
#endif
bool UT_CharToHex(char **p, uint8 *pValue);
bool UT_StrToUint8(char **p, uint8 *pValue);
bool UT_StrToUint16(char **p, uint16 *pValue);
bool UT_StrToUint32(char **p, uint32 *pValue);
bool UT_StrToUint8xN(char **p, uint8 *pValue, uint16 N);
bool UT_StrToUint8xN_Reverse(char **p, uint8 *pValue, uint16 N);
#ifdef FCC
bool UT_StrToDecxN(char **p, uint32 *pValue, uint16 N);//by cbq 20241024
bool UT_StrToHexxN(char **p, uint32 *pValue, uint16 N);//by cbq 20241024
#endif
void UT_Uint8ToHex(uint8 *p, char **ppStr);
void UT_Uint8xNToHex(uint8 *p, char **ppStr, uint16 N, char Seperator);
void UT_Uint8xNToHex(uint8 *p, char **ppStr, uint16 N, char Seperator);
void UT_Uint8xNToHex_Reverse(uint8 *p, char **ppStr, uint16 N,char Seperator);

#define UT_Uint16ToHex(p,ppStr)   UT_Uint8xNToHex_Reverse((uint8*)p,ppStr,2,0)
#define UT_Uint32ToHex(p,ppStr)   UT_Uint8xNToHex_Reverse((uint8*)p,ppStr,4,0)

void UT_NumToIntStr(uint32 Value, char **ppStr, uint16 Num);

#define UT_Uint8ToIntStr(V,ppStr)  UT_NumToIntStr((uint32)V,ppStr,2)
#define UT_Uint16ToIntStr(V,ppStr) UT_NumToIntStr((uint32)V,ppStr,4)
#define UT_Uint32ToIntStr(V,ppStr) UT_NumToIntStr((uint32)V,ppStr,9)

uint32  UT_GetInt(char **p, int DefaultValue);
uint32  UT_GetHex(char **p, int DefaultValue);
void    UT_GetStr(char **p, char *Buffer);
void    UT_StrToLower( char *pData, uint16 Len );
int     UT_GetSignedInt(char **p, int DefaultValue);
char *  UT_tolower(char *pBuf);
char *  UT_toupper(char *pBuf);
uint32  UT_atoi(char *p, uint32 DefaultValue);
bool    UT_GetHexByte(char **ppBuf, uint8 *Byte);
bool    UT_GetHexWord(char **ppBuf, uint16 *Word);
char * UT_GetConfigValueText(char *buf, uint8 ix);
char * UT_GetValidConfigValuesById(uint16 Id);
char * UT_GetValidConfigValuesByIndex(uint16 Ix);
char * UT_GetValidConfigValuesByAttr(tConfigAttr *attr);
char * UT_SetConfig(char *errBuf, uint8 ix, char *pSetting, bool trap, bool force);
bool TM_GetMACAddr(char *s, uint8 *MacAddr);
//bool TM_GetStoredMACAddr(uint8 *pMAC_ADDR);
uint16 TM_GetNumMACAddr(void);
char *  UT_PrettyNumber(char *buf, sint32 num);

bool   UT_isequal(char *s1, char *s2, uint16 length);
uint8  AT_CharToLower( uint8 Char );
void   AT_StrToLower( char *pData, uint16 Len );
uint32 AT_StrToU32( char *pData, uint8 *pLen );

#endif // UTILITIES_H
