//------------------------------------------------------------------------------
//
//  Project:      TheProjectName
//
//  File name:    TargetManagerAPI.h
//
//  Author:       Charles Liu
//
//  Created:      03/09/2000
//
//  Description:
//
//    The description goes here...
//
// History:
//
// 10/16/07 - jf - Modified for STR71x.
//
//  Copyright (c) 2003 Zeevo Inc. All rights reserved.
//  Copyright (c) 2007 AmpedRF Inc. All rights reserved.
//
//------------------------------------------------------------------------------

#ifndef TARGETMANAGERAPI_H
#define TARGETMANAGERAPI_H

#include "Utilities.h"


// Data Type Conversion Utilities
#define TM_API_SkipBlanks(p)                    UT_SkipBlanks(p)
#ifdef FCC
#define TM_API_FindBlank(p)                     UT_FindBlank(p)         //by cbq 20241024
#endif
#define TM_API_CharToHex(p,pValue)              UT_CharToHex(p,pValue)
#define TM_API_StrToU8(p,pValue)                UT_StrToUint8(p,pValue)
#define TM_API_StrToU16(p,Value)                UT_StrToUint16(p,pValue)
#define TM_API_StrToU32(p,pValue)               UT_StrToUint32(p,pValue)
#define TM_API_StrToBU8(p,pValue,N)             UT_StrToUint8xN(p,pValue,N)
#define TM_API_StrToBU8Rev(p,pValue,N)          UT_StrToUint8xN_Reverse(p,pValue,N)
#define TM_API_U8ToHex(p,ppStr)                 UT_Uint8ToHex(p,ppStr)
#define TM_API_BU8ToHex(p,ppStr,N,Sep)          UT_Uint8xNToHex(p,ppStr,N,Sep)
#define TM_API_BU8ToHexRev(p,ppStr,N,Sep)       UT_Uint8xNToHex_Reverse(p,ppStr,N,Sep)
#define TM_API_U16ToHex(p,ppStr)                UT_Uint16ToHex(p,ppStr)
#define TM_API_U32ToHex(p,ppStr)                UT_Uint32ToHex(p,ppStr)
#define TM_API_Uint8ToIntStr(V,ppStr)           UT_Uint8ToIntStr(V,ppStr)
#define TM_API_Uint16ToIntStr(V,ppStr)          UT_Uint16ToIntStr(V,ppStr)
#define TM_API_Uint32ToIntStr(V,ppStr)          UT_Uint32ToIntStr(V,ppStr)

// Memory
#define TM_API_MemMove(dst,src,len)             memmove(dst,src,len)
#define TM_API_MemCpy(dst,src,len)              memcpy(dst,src,len)
#define TM_API_MemCmp(p1,p2,len)                memcmp(p1,p2,len)
#define TM_API_MemSet(ptr,val,len)              memset(ptr,val,len)
#define TM_API_MemSetZero(ptr,len)              memset(ptr,0,len)
#define TM_API_Memchar(ptr,val,len)             memchr(ptr,val,len)


//---------------------------------
//   UART Definitions
//---------------------------------
#define TM_API_UartMain_Configure(pCfgStruct)     TM_UartConfigure(eTM_MainUart,pCfgStruct)
#define TM_API_UartDriverInitialization(UartType) TM_UartDriverInitialization(UartType)


// Flash Driver
#define TM_API_GetFlashWritePtr(Id,Size)        TM_GetFlashWritePtr(Id,Size)
#define TM_API_FlashWriteDone(Id)               TM_FlashWriteDone(Id)
#define TM_API_GetFlashReadPtr(Id)              TM_GetFlashReadPtr(Id)

//------------------------------------------------------------------------------
// Helpful macros
//------------------------------------------------------------------------------


#endif //TARGETMANAGERAPI_H
//------------------------------------------------------------------------------
// End of TargetManagerAPI.h
