/*******************************************************************************
* Project:      Amped'RF WIFI
* File name:    TM_UARTDriver.h
* Author:       Grace
* Created:      04/10/2014
* Description:  Header for TM_UartDriver.c, TM_UartHandler.c, TM_HciHandler.c
*
* Copyright (c) 2014 Amped'RF Inc. All rights reserved.
*******************************************************************************/
#ifndef TM_UART_DRIVER_H
#define TM_UART_DRIVER_H

#include "AT_Common.h"
#include "TM_Device.h"
#include "GKI_uart.h"
#include "Pool.h"

//------------------------------------------------------------------------------
//  Includes
//------------------------------------------------------------------------------

//#define UART_TypeDef            USART_TypeDef

typedef struct
{
	u8 			  *pData;  // This must match tBufferHeader structure
	u16			  DataLen;
}T_UartMSG;

#define UART_QUEUE_COUNT               ( 20 )
#define UART_QUEUE_BUFF_SIZE           ( sizeof(T_UartMSG) )

#define UDPTX_QUEUE_COUNT               ( 10 )
#define UDPTX_QUEUE_BUFF_SIZE           ( sizeof(T_UartMSG) )

//------------------------------------------------------------------------------
// Queue sizes, buffer Sizes, number of links and buffers
//------------------------------------------------------------------------------
#ifdef ENB_BYPASS
#define POOLNUM 4
#define POOLSIZE           (*(uint16 *)TM_GetFlashReadPtr(VAR_ID_OutMtuSize))
#define TXPOOLNUM 4         // bcolias was 6
#define TXPOOLSIZE 1500     //1500 is max tcp/udp mtu size
#else
#define POOLNUM 4
#define POOLSIZE           (*(uint16 *)TM_GetFlashReadPtr(VAR_ID_OutMtuSize))
#define TXPOOLNUM 4
#define TXPOOLSIZE 500
#endif

#define AT_MAX_HOST_DATA_LENGTH			POOLSIZE
#define TM_UART_MAIN_RX_DMA_SIZE        ((AT_MAX_HOST_DATA_LENGTH * 2)+400)
#define TM_UART_TX_LINKLIST_NUM         12

#define BIGPACKET  1         // This removes Nagle. Was --  ((POOLSIZE<700)? (0) : (1)) // Grace add for TCP Nagle algorithm switch

//------------------------------------------------------------------------------
//  UART Defines
// databits:    0=7bit + parity, 1=8bit, 2 =8bit  + parity, 3=8bit + wakebit, 4=9bit
// parity:      0=even/none, 1=odd
// stopbits:    0=.5sb, 1=1sb, 2=1.5sb, 3=2sb
//------------------------------------------------------------------------------
#define AT_UART_DEFAULT_BAUDRATE        *(uint32 *)TM_GetFlashReadPtr(VAR_ID_UartBaudrate)

#define AT_UART_MAX_TIMEOUT             127
#define AT_UART_DEFAULT_TIMEOUT         *(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartTimeout)
#define AT_UART_DEFAULT_PARITY          *(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartParity)
#define AT_UART_DEFAULT_DATA_BITS       *(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartDataBits)
#define AT_UART_DEFAULT_STOP_BITS       *(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartStopBits)
#define AT_UART_DEFAULT_FLOW_CONTROL    *(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartFlowControl);
#define TM_SetUartChrTimeout(Uart,timeout)  USART_SetGuardTime(Uart, timeout)
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//  Externs
//------------------------------------------------------------------------------
//extern	USART_TypeDef	*UartAddress[];

//------------------------------------------------------------------------------
//  Types
//------------------------------------------------------------------------------

typedef struct {
    void * pBuffer;
    void * pData;
    u16 Length;
    bool   Busy;
} tTxLink;

typedef struct {
    tTxLink Link[TM_UART_TX_LINKLIST_NUM];
    u16 Head;
    u16 Tail;
    u16 Count;
    u16 MaxCount;
} tTxLinkList;

typedef struct {
    u16              Pin;
//    DMA_Stream_TypeDef *DmaChannel;
    u8               *DmaBuffer;
    u16              DmaSize;
    u16              DmaLowWM;
    u16              DmaHighWM;
    u16              DmaPnt;
    u8               NVIC_IRQChannel;
    uint32           ITPending;
    bool             Initialized;
    u16              PoolBufNum;
    u16              PoolBufSize;
    tpBP_MemPool        pPool;
    tBP_PoolNotifyFunc  PoolReleaseFunc;
    uint32              SWI;
    u8               SWIChannel;
	u8				idel;				//will.zhang
} tUartRx;

typedef struct {
    u16              Pin;
    bool                FlowCtrlEnable;
//    DMA_Stream_TypeDef *DmaChannel;
    u16              DmaSize;
    u8               NVIC_IRQChannel;
    uint32              ITPending;
    bool                Initialized;
	uint16              PoolBufNum;
    uint16              PoolBufSize;
    tpBP_MemPool        pPool;
    tBP_PoolNotifyFunc  PoolReleaseFunc;
    tTxLinkList         LinkList;
} tUartTx;

typedef struct {
    u16              Rx;
    u16              Tx;
    u16              RTS;
    u16              CTS;
} tUartPins;




///////////////////////////
// UART device structure //
///////////////////////////
typedef struct {
//    UART_TypeDef    *Device;
    u8           IRQChannel;
    u8           IRQPriority;
    tUartPins       Pin;
    tUartRx         Rx;
    tUartTx         Tx;
    bool            Initialized;
//    tUartConf       Config;
    uint32          Baudrate;
    u16          HardwareFlowControl;
} tTM_UartDev;


#define PORT_SOURCE(x)  (x>>4)
#define PORT_BASE(x)    PortBase[x>>4]
#define PORT_PIN(x)     (x&0x0F)
#define PORT_MASK(x)    (1<<PORT_PIN(x))
#define TM_MainUartReceiveEnable(enb)       GPIO_BitWrite(PORT_BASE(IO_MAIN_RTS), PORT_PIN(IO_MAIN_RTS), !enb)

extern tTM_UartDev TM_UartDev[1];
extern uint16 FwdUartPnt;

void TM_SendPendingRxDmaMsg(void);
void TM_SendPendingRxDmaMsgFromISR(void);


//------------------------------------------------------------------------------
//  Depreciated functions
//------------------------------------------------------------------------------
void   TM_DmaRxFlush(tTM_UartType u);
uint16 TM_DmaRxCount(tTM_UartType u);
uint16 TM_DmaRxCountPeek(tTM_UartType u, uint8 *pbyte);
uint16 TM_DmaRxSpaceAvailable(tTM_UartType u);
bool   TM_DmaAboveLowWM(uint16 u);
uint16 TM_CopyDmaBuf(uint16 u, uint8 *pDestBuf, uint16 destLength);
void   TM_DumpDmaData(uint16 u, uint16 dataLength);

uint16 AT_UartRxCallBack(uint16 u, uint16 length);
void vUartRecvDataTask( void *pvParameters );
void vUartTask( void *pvParameters );
void TM_UartDriverInitialization(tTM_UartType u);
/*
bool TM_SetupUart(tTM_UartType      u,
                  tTM_UartDataBits  DataBits,
                  tTM_UartStopBits  StopBits,
                  tTM_UartParity    Parity,
                  tTM_UartBaudRate  BaudRate);
tIoStatus TM_UartConfigure(tTM_UartType u, tUartConf* pConfigStruct);
*/
void TM_UartRxHandlerIRQ(u16 u, tTM_InterruptSource iSrc);
void MainUartBufRelease(tBP_Pool *pool);

void vUDPTask( void *pvParameters );

#endif // TM_UART_DRIVER_H

//------------------------------------------------------------------------------
// End of TM_UARTDriver.h
