/*******************************************************************************
* Project:      Amped'RF Wifi
* File name:    TM_PioDef.h
* Author:       Bill Colias
* Created:      09/15/2008
* Description:  General peripheral IO support routine header.
*
* Copyright (c) 2008 Amped'RF Inc. All rights reserved.
*******************************************************************************/

#ifndef TM_PIO_DEF_H
#define TM_PIO_DEF_H


#include "AT_Common.h"
//#include "GKI_io.h"

// macro for defining PIO values
#define DEFINE_GPIO(io, irq)    {io, irq}
#define UNDEFINED_GPIO          {IO_UNDEFINED, 0}
#define PIO_UNDEFINED           IO_UNDEFINED
#define PIO_MAX                 16

#define TM_InvertPioData(bitnum)
#define TM_NoInvertPioData(bitnum)
#define TM_MaskPioInt(bitnum)
#define TM_UnmaskPioInt(bitnum)
#define TM_SetPioMask(bitmask)


typedef struct {
  //  uint8           Valid;
    u16             io;
    uint8           ExtChannel;
} tPioGpioMap;

extern const tPioGpioMap PioGpioMap[PIO_MAX];



typedef struct {
    uint32 ExtSource : 8;
    uint32 PioSource : 8;
    uint32 PioValue  : 8;
    uint32 ZeroFill  : 8;
} tPioInterrupt;

typedef struct {
    uint8 Enabled;
    uint8 PioSource;
    uint8 PioValue;
    uint8 ExtMode;
    uint16 SigNo;
//  tExtInterruptCallback *PioCallback;
} tExtInterrupt;


//------------------------------------------------------------------------------
//  Public Globals
//------------------------------------------------------------------------------
extern char * TM_PIO_MODE_TEXT[8];
extern tExtInterrupt TM_ExtInterrupt[];

//------------------------------------------------------------------------------
//  Public Functions
//------------------------------------------------------------------------------
void   TM_InitPio(void);
void   TM_SetPioAsOutput(uint16 bitnum);
void   TM_SetPioAsInput(uint16 bitnum);
uint16 TM_GetPioMode(uint16 bitnum);
void   TM_SetPioAsInputWP(uint16 bitnum, uint8 wp);
void   TM_SetPioAsInputTRI(uint16 bitnum);
uint8  TM_PioCnf(uint8 PioSource);
uint8  TM_PioMode(uint8 PioSource);
uint8  TM_GpioRead(uint8 PortSource, uint8 n);
void TM_LED_Config(uint8 x);
void TM_LED_SetValue(uint8 x, bool value);
void TM_ConfigConnectLED(void);
void TM_ConnectLED_ON(void);
void TM_ConnectLED_OFF(void);
void    TM_SetPio(u16 pio);    // Set PIO bit to one
void    TM_ResetPio(u16 pio);  // Set PIO bit to zero
bool    TM_ReadPio(u16 pio);   // Read PIO bit
u16     TM_GPIO(u16 pio);      // Return GPIO reference


#endif //TM_PIO_DEF_H
//------------------------------------------------------------------------------
// End of TM_PioDef.h
