//------------------------------------------------------------------------------
//
// TM_FlashManager.c
//
// Writer:	Frank
// Created: 10/11/2017
// Abstract the flash operation port and use new mechmism RAM link table, 
// make read/write operation quckily, at the same time make it easy porting for
// different flash type. 
// easily ported for any other flash types.
// 
// (C) Copyright 2017 Amped RF Technology
//------------------------------------------------------------------------------

#ifndef TM_FLASHMANAGER_H
#define TM_FLASHMANAGER_H

//#include "AT_Common.h"
#include "string.h"

typedef struct t_PSK
{
  bool   NeedUpdate;
  uint8  psk[32];
} t_PSK;

//-----------------------------------------------------------------------------
//  Micros
//-----------------------------------------------------------------------------
#define FM_RECORD_HEADER_SIZE   8
#define FM_POOL_START_OFFSET    4

#define FM_POOL_NOT_INITIALIZED 0xFFFFFFFF
#define FM_POOL_INITIALIZED     0x5A5AFFFF
#define FM_POOL_READY           0x0000FFFF
#define FM_POOL_EXPIRED         0x0000AA55

#define FM_INVALID_POOL         0xFF
#define FM_UNUSED_ID            0xFFFF

#define FM_VAR_TEXT_MAX         460                  
#define FM_MAX_REC_SIZE         460

#define	IMAGE_INVALID_VALUE			(0x0badc0de)
#define MAC_MODIFY_MARK_ADDR       	(0x1ff8)  
#define BOOTLOADER_VALID_ADDRESS 	(0x1ffc)
#define APP_VALID_ADDRESS 			(0x2004)        

//-----------------------------------------------------------------------------
//  types
//-----------------------------------------------------------------------------
typedef enum {
	eCS_Status_NotInitialized=0,
	eCS_Status_Initialized,
	eCS_Status_Ready
}CS_Status;

typedef struct {
  	u32 location;
  	u32 size;
} tFlashPool;
	
typedef struct {
	uint32      valid;
	uint16      id;   
	uint16      size;
} tFlashDataHdr;

typedef struct {
	uint16      id;
	uint16      size; 
	uint32		address;
} tFlashCfgMem;

typedef struct CFG_SYS_T {
  
void (*flash_erase)(u32 addr, u32 len); 
void (*flash_write)(u32 addr, u8 *buf, u32 len); 
void (*flash_read)(u32 addr, u8 *buf, u32 len);

tFlashPool pool[2];
tFlashCfgMem *pCfgMem;
u8 *pWriteBuf;
u32 location;
u32 size_used;
u32 unused_addr;

CS_Status status;
u16 write_buf_size;

u8 being_initialized;
u8 pool_working_idx;
u8 cfg_num;
} tCfgSys;

//------------------------------------------------------------------------------
//     prototypes declare
//------------------------------------------------------------------------------
extern tCfgSys CfgSystem;
void TM_CfgSysInit(tCfgSys *pCfgSys, u32 location, u32 sector_size);
void TM_FlashInvalidate(void);
void TM_FlashInvalidateApp(void);
void TM_FlashInvalidateBootloader(void);
u16 TM_GetMacAddressModificationTimes(void);
u16 TM_MarkMacAddressModification(u16 times);
void *TM_GetFlashWritePtr(uint16 Id, uint16 Size);
void TM_FlashWriteDone(uint16 Id);
void *TM_GetFlashReadPtr(uint16 id);

#endif //TM_FLASHMANAGER_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/
