/*******************************************************************************
* Project:      Amped'RF WIFI
* File name:    TM_Device.h
* Author:       Grace
* Created:      04/10/2014
* Description:  Definitions for device peripherals
*
* Copyright (c) 2014 Amped'RF Inc. All rights reserved.
*******************************************************************************/
#ifndef TM_DEVICE_H
#define TM_DEVICE_H

#include "AT_Common.h"
#include "FreeRTOS.h"
#include "timers.h"
//#include "TM_PioDef.h"

//#include "GKI_uart.h"
//------------------------------------------------------------------------------
//  Cortex UART Defines
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//  Macros
//------------------------------------------------------------------------------

#define eTM_USART1      0

typedef unsigned char tTM_UartType;

#define AT_MAX_ESCAPE_SEQ_LENGTH 6
#define AT_DEFAULT_ESCAPE_SEQ_LENGTH             6
#define AT_DEFAULT_ESCAPE_SEQ                    "^#^$^%"
#define AT_MAX_TEMP_BUFF_LENGTH 384

typedef enum tAT_MainState{
  eAT_StartState=0,             // for state initialization
  eAT_CommandState,             // looking for AT command
  eAT_BypassState,              // bypass state
}tAT_MainState;

typedef struct tTM_Device{
  bool			    InUse;
  uint32 			ipaddr;
  uint8				MacAddr[6];
  //uint16			Port;
}tTM_Device;

typedef struct tAT_AppVar{
  bool			    HostEvents;
  bool              CheckCommandID;  // true for checking Command ID
  bool              fLastCmdCharCRLF;// whether last cmd char processed was CR/LF
  uint8				MainState;
  u16           	BufIndx;         // Command Buffer Index
  bool              Connected;       // Indicates module connection status udp/tcp
  bool              Joined;          // Indicates module join a network
  bool				SocketOpen;
  char              TmpBuf[AT_MAX_TEMP_BUFF_LENGTH+1]; // Temp data storage + null
  char              EscapeSeq[AT_MAX_ESCAPE_SEQ_LENGTH+1];
  uint8             EscapeSeqLength;
  uint8				Protocol;
  uint8 			MPmode;
  uint8             acAp[32];
  uint8             sacPsk[64];
  bool              SleepEnable;//michael_lowpower
}tAT_AppVar;


//------------------------------------------------
//    Define UARTs
//------------------------------------------------
#define eTM_MainUart	    eTM_USART1
#define TM_MainUart         USART1
#define MAIN_UART_DR_BASE   (USART1_BASE+4)

typedef enum {
    TM_IntSrc_IDLE,
    TM_IntSrc_FULL,
    TM_IntSrc_HALF,
    TM_IntSrc_SWI,
    TM_IntSrc_RXNE,
    TM_IntSrc_ERR
} tTM_InterruptSource;

//------------------------------------------------------------------------------
// All Cortex priority settings go here from 1 (highest) to 15 (lowest)
//------------------------------------------------------------------------------
enum {
    TM_HighestPriority=2,
    TM_XtiPriority,
    TM_RtcPriority,
    TM_ExtPriority,
    TM_I2SPriority,
    TM_MainUartPriority,
    TM_DebugUartPriority,
    TM_SpareUartPriority,
    TM_LowestPriority
};
// from TM_IoDriver.h
typedef enum {
    eTM_Success,
    eTM_UninitDevice,
    eTM_UnacceptableParamatersSetting,
    eTM_DeviceIsBusy,
    eTM_Aborted,
    eTM_OverrunError,
    eTM_ParityError,
    eTM_FramError,
    eTM_BreakError,
    eTM_NoRxActivity,
    eTM_NoTxActivity,
} tIoStatus;

#define PA9     0x09
#define PA10    0x0A
#define PA11    0x0B
#define PA12    0x0C

//------------------------------------------------------------------------------
// IO Definitions
//------------------------------------------------------------------------------
#define TM_UART1_TX_PORT	        PA9 	// A9     UART1 Tx
#define TM_UART1_RX_PORT	        PA10	// A10    UART1 Tx
#define TM_UART1_CTS_PORT           PA11    // A11    UART1 CTS
#define TM_UART1_RTS_PORT           PA12    // A12    UART1 RTS

#define OSCLOCK_INTERVAL    10
#define MP_PACKET_TIMEOUT   3000

//---------------------------------------
// Prototypes
//---------------------------------------
void vOSClockCallback( TimerHandle_t pxTimer );
void vMPpcaketTimerCallback( TimerHandle_t pxTimer );
void vPartESCTimerCallback( TimerHandle_t pxTimer );
void vRcvInfoCallback( TimerHandle_t pxTimer );
void CreateTimers(void);

#define UART_RX_SIZE (2048)
#define UART_LIMIT_UP                   (UART_RX_SIZE-500)
#define UART_LIMIT_DOWN                 (100)
typedef enum{
    DATA_NONE=0,
    DATA_RUN,
    DATA_PEND
}DataStateType; 
typedef struct
{
//    u8 UartRxBuf[UART_RX_SIZE];
    u16 DataHead;
    u16 DataTail;
    DataStateType DataState;
}T_UartBufData;

#define ALLOCATE_BUFFER(x)      pvPortMalloc(x)
#define FREE_BUFFER(x)          vPortFree(x);x = NULL

#endif // TM_DEVICE_H

//------------------------------------------------------------------------------
// End of TM_Device.h
