/*********************************************************************************************************
*                                         Tiny file system
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File		: tinyFS.h
* Version	: V1.0.0
* Brief:    : This file contains all the functions prototypes for the tiny file system.
**********************************************************************************************************/
#ifndef __TM_CONFIG_H
#define __TM_CONFIG_H

#include "ach118x_type.h"
#include "buildVersion.h"
#include "Custom.h"
#include "AT_Config.h"

//Configuration type.
typedef struct _confVarSetting_t {
    bool flgType;
    u32   ipAddrType;
    u8    macAddrType[6];
    u32   intType;
    float floatType;
    char  stringType[32];
} confVarSetting_t;

//File system interface.
#define getStorageInfo(info)            fastFsGetStorageInfo(STORAGE2)
#define formatStorage()                 fastFsInitStorage(STORAGE2)
#define saveFile(name, addr, size)      fastFsSaveFile(STORAGE2, name, addr, size)
#define openFile(name, addr)            fastFsOpenFile(STORAGE2, name, addr)

//Configuration setting buffer.
extern confVarSetting_t confVarSetting;

//APIs
char* str_tolower(char* pStr);
char* str_toupper(char* pStr);
bool TM_GetMACAddr(char* s, u8* MacAddr);
char* UT_GetValidConfigValuesByAttr(tConfigAttr* attr);
char* UT_GetValidConfigValuesById(u16 Id);
char* UT_GetValidConfigValuesByIndex(u16 ix);
char* UT_SetConfig(char* errBuf, u8 ix, char* pSetting, bool trap, bool force);
void* UT_RdConfig(u16 id, void* buff);
u16 TM_GetNumMACAddr(void);
void TM_SetMACAddrChangeTimes(uint16 times);

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/
