/*********************************************************************************************************
*                                     Pool Additional functions
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : PoolAdd.h
* Version : V1.0.0
* Brief   : This file contains all the functions prototypes for Pool addition.
**********************************************************************************************************/
#ifndef _POOLADD_H
#define _POOLADD_H

#include <stdint.h>
#include "AT_Common.h"
#include "common.h"
#include "Pool.h"
#include "TM_UARTDriver.h"
#include "streamList.h"

#ifdef __cplusplus
	extern "C" {
#endif

//Memory block node.
typedef struct _tBP_MemBlockNode {
    streamNode_t node;
    void* block;
    uint32_t payload;
} tBP_MemBlockNode;

//Memory block management.
typedef struct _tBP_MemBlockMng {
    streamList_t idleList;
    streamList_t usedList;
    streamList_t sendList;
    tBP_MemBlockNode* blockNode;
} tBP_MemBlockMng;

//Variables.
extern tBP_MemBlockMng  memBlockTxMng;
extern tBP_MemBlockMng  memBlockRxMng;
extern tBP_MemBlockNode memBlockTxNode[TXPOOLNUM];
extern tBP_MemBlockNode memBlockRxNode[POOLNUM];

//APIs
extern void BP_MngInit(tBP_MemBlockMng* mng, tBP_MemBlockNode* staNode, uint32_t nodeNum);
extern uint32_t BP_GetIdleBlockCnt(tBP_MemBlockMng* mng);
extern uint32_t BP_GetUsedBlockCnt(tBP_MemBlockMng* mng);
extern uint32_t BP_GetSendBlockCnt(tBP_MemBlockMng* mng);
extern tBP_MemBlockNode* BP_BindBlockNode(tBP_MemBlockMng* mng, void* buf);
extern tBP_MemBlockNode* BP_AddBlockToProcessQueue(tBP_MemBlockMng* mng);
extern void BP_DeBindBlockNode(tBP_MemBlockMng* mng);

#ifdef __cplusplus
	}//extern "C"
#endif

#endif

/******************************** (C) COPYRIGHT ART ****END OF FILE****/

