
#ifndef BACKPLANE_H
#define BACKPLANE_H

// Forward declaration
struct tBP_Pool;

// Callback function for mem pool
typedef void (*tBP_PoolNotifyFunc)(struct tBP_Pool*);

// Memory Block Head
typedef struct tBP_MemBlock {
  struct tBP_Pool     *pOwnerPool;
  struct tBP_MemBlock *pNext;
  struct tBP_MemBlock *pMemHeader;
} tBP_MemBlock, *tpBP_MemBlock;

// Memory Pool
typedef struct tBP_Pool {
  char                *Name;
  uint32               NoOfBlocks;
  uint32               BlockSize;
  uint32               BlockUse;
  uint32               BlockUsePeak;
  void *               TopAddress;
  tBP_PoolNotifyFunc   NotifyFunc;
  struct tBP_Pool     *pNextPool;
  tpBP_MemBlock        pFreeBlock;
} tBP_Pool, *tpBP_Pool, tBP_MemPool, *tpBP_MemPool;


// Reserve a chunk of memory of a certain memory type (MemType) for a pool
uint8* BP_ReservePoolMemory(uint32 NoOfBlocks, uint32 BlockSize);


tpBP_MemPool BP_CreatePool(char *Name, uint8 *pMem, uint32 NoOfBlocks,
                          uint32 BlockSize, tBP_PoolNotifyFunc PoolNotifyFunc);

tpBP_Pool BP_ReserveCreatePool(char *Name, uint32 NoOfBlocks, uint32 BlockSize,
                               tBP_PoolNotifyFunc PoolNotifyFunc);


// pointers to mem pools
extern tpBP_Pool *pSysTimeoutPool;
extern tpBP_Pool *pPBUF_Pool;



//------------------------------------------------------------------------------
// Reset a pool to its create state.
void BP_ResetPool(tpBP_Pool pPool);

//------------------------------------------------------------------------------
// Get a memory block from a pool (pMemPool). Returns NULL if the pool is empty.
void* BP_GetFromPool(tpBP_MemPool pMemPool);
void* BP_GetFromPoolFromIRQ(tpBP_MemPool pMemPool);
//------------------------------------------------------------------------------
// Return a block to the pool.
void BP_ReturnToPool(void *p);

// Check for pool memory
bool BP_IsPoolMemory(void *p);

u16 BP_PoolNum(void);
tpBP_Pool BP_GetPool(u16 n);
void BP_ShowPoolData(void);

#endif //BACKPLANE_H

//------------------------------------------------------------------------------
// End of BackPlane.h
