/*******************************************************************************
* Project:      Amped'RF WIFI
* File name:    AT_Config.h
* Description:  Configuration settings
*
* Copyright (c) 2014 Amped'RF Inc., AR Technology  All rights reserved.
*******************************************************************************/
#ifndef AT_CONFIG_H
#define AT_CONFIG_H


//------------------------------------------------------------------------------
//  Build
//------------------------------------------------------------------------------
#define CFG_BUILD_NUMBER     001        // Change this to the Build number
#define CFG_BUILD_COMMENT    "AmpSerial v1.0"
                                        //   "for Hari with Prbmux = 3008"
#define CFG_BUILD_TIME  __DATE__ " " __TIME__
#define CFG_COPYRIGHT "Copyright (c) 2008 Amp'ed RF, Inc"


//  Flash DataBase Data record IDs
#define TMFM_1ST_CONFIG_ID  0x1001  // 1st config variable ID
#define TMFM_1ST_DYNAMIC_ID 0x2001  // Dynamic only record ID base
#define TMFM_1ST_CUSTOM_ID  0x3001  // Custom record ID base
#define TMFM_1ST_USER_ID    0x4001  // User record ID base


// Flash Manager
enum {
    TM_FLASH_MODEM_DB_INIT = TMFM_1ST_USER_ID,
	TM_FLASH_PSK,
    TM_FLASH_LAST_USER_ID
};

/***************************************
* Define Dynamic Config constants here *
****************************************/
#define CONFIG_MAX_VARNAME_SIZE 24  // Max size of config name variables

#define CONFIG_ATTR_HIDE     0x80   // hide variable
#define CONFIG_ATTR_HEX      0x40   // display as hex
#define CONFIG_ATTR_RO       0x20   // read only
#define CONFIG_ATTR_MASK     0x1F   // mask
enum {
    CONFIG_TYPE_STRING=0,
    CONFIG_TYPE_BOOL,
    CONFIG_TYPE_UINT8,
    CONFIG_TYPE_UINT16,
    CONFIG_TYPE_UINT32,
    CONFIG_TYPE_MACADDR,
    CONFIG_TYPE_BAUDRATE,
    CONFIG_TYPE_PARITY,     // none, odd, even
    CONFIG_TYPE_DATABITS,   // 7p, 8, 8p. 8w, 9
    CONFIG_TYPE_STOPBITS,   // .5, 1, 1.5, 2
    CONFIG_TYPE_UINT4,      // 0 - 15
    CONFIG_TYPE_CPU_MHZ,
    CONFIG_TYPE_GPIO,       // none, 0-15
    CONFIG_TYPE_MASTER_SLAVE,
    CONFIG_TYPE_SSID,
    CONFIG_TYPE_NUM,
};


typedef struct {
    uint8   Hide    : 1;
    uint8   Hex     : 1;
    uint8   RO      : 1;
    uint8   Type    : 5;
} tConfigAttr;


typedef struct {
    uint16  Id;
    char    Name[32];
    char    Setting[32];
    tConfigAttr Attr;
} tConfigVar;

extern tConfigVar ConfigVar[];
extern uint16 ConfigVarMax;

/**********************************
* Define config variable IDs here *
***********************************/
enum {
    VAR_ID_BuildVersion = TMFM_1ST_CONFIG_ID,
    VAR_ID_FlashVersion,
    VAR_ID_DeviceName,
    VAR_ID_MACaddress,
    VAR_ID_AutoSniffTimeout,
    VAR_ID_AutoSniffInterval,
    VAR_ID_EnablePowerControl,
    VAR_ID_SPIMode,
    TMFM_LAST_CONFIG_ID
};
#define VAR_ID_COUNT  (TMFM_LAST_CONFIG_ID - TMFM_1ST_CONFIG_ID)


/******************************************
*  Helpful Defines for config variables   *
*******************************************/
#define TM_AUTO_SNIFF_ENABLE        (*(u8*)UT_RdConfig(VAR_ID_AutoSniff, &confVarSetting.intType))
#define TM_AUTO_SNIFF_TIMEOUT       (*(u16*)UT_RdConfig(VAR_ID_AutoSniffTimeout, &confVarSetting.intType))
#define TM_AUTO_SNIFF_INTERVAL      (*(u16*)UT_RdConfig(VAR_ID_AutoSniffInterval, &confVarSetting.intType))
#define TM_DEVICE_NAME              ((char*)UT_RdConfig(VAR_ID_DeviceName, &confVarSetting.stringType[0]))


#endif //AT_CONFIG_H
//------------------------------------------------------------------------------
// End of AT_Config.h

