//------------------------------------------------------------------------------
//
//  File name:    AT_Cmd.h
//
//
//  Description:
//
//     Defines stuff particular to interpreting commands of the module.
//
//  Copyright (c) 2014 Amp'ed RF Tech Inc. All rights reserved.
//
//------------------------------------------------------------------------------
#ifndef  _AT_CMD_H_
#define  _AT_CMD_H_

#include <freertos.h>
#include <task.h>
#include <timers.h>
#include <queue.h>

#include "cw1200_common.h"
#include "AT_Common.h"
#include "TM_Device.h"

//--------------------------------------------------------------------
// Used in AT_network.c and AT_comm.c
//--------------------------------------------------------------------
typedef struct tTM_Client{
  bool			    InUse;  
  uint32 			ipaddr;
#if 1//def LWIP_IPV6    
  //struct lw_in6_addr sin6_addr;     /* IPv6 address                */
  uint32 sin6_addr[4];
#endif  
  int 				clientid;
}tTM_Client;

extern struct cfg80211_registered_device *g_prdev;
extern struct ieee80211_sub_if_data *gp_sdata[CW12XX_MAX_VIFS];
extern struct wpa_global *global;
extern void config_connect(char *ssid, char *password);
extern enum app_running_status g_app_status;
extern tTM_Client *pCientList;

#if 1//LWIP_IPV6
extern struct sockaddr_storage sock_sendaddr;
extern struct sockaddr_storage client_addr;
#else
extern struct sockaddr_in client_addr;
extern struct sockaddr_in sock_sendaddr;
#endif
extern tTM_Device *pDeviceInfo;


extern int socketid;
extern int connectfd;
extern int listenfd;
extern xTaskHandle xUDPRxHandle;
extern xTaskHandle xTCPServerHandle;
extern xTaskHandle xTCPRxHandle;
extern xQueueHandle xUDPTxQueue;
extern xQueueHandle xIPSendQueue;
extern TimerHandle_t xMPpacketTimer;
void vMPpcaketTimerCallback( TimerHandle_t pxTimer );

extern uint8 MPTaskCreated;
extern uint8 OpenSocketCount;
//--------------------------------------------------------------------

// Prototypes
int  IPSendData_rx(void *pData, u16 Length, u16 force_tx);



#define USE_BYPASS
#define USE_IPSEND


#define MAXSOCKFD 5
//--------------------------------------------------------------------
//  function types
//--------------------------------------------------------------------

// define AT command function type
/*
typedef void (*tAtCmdFunc)(char **ppBuf);
// AT event string table
typedef struct tAT_EvtTbl{
  const char *pEvtStr;              // event string
}tAT_EvtTbl;
// AT command table
typedef struct tAT_CmdTbl{
  const char            *pCmdStr;   // command string
  tAtCmdFunc            CmdFunc;    // command function
}tAT_CmdTbl;
*/
/*
typedef enum tScan_Type {
	scan_timeout,
	scan_complete,
	scan_skip
} tScan_Type;
*/

#define	CONN_SCAN_TIMEOUT		0x0001
#define	CONN_SCAN_2G_COMPLETE	0x0002
#define	CONN_SCAN_5G_COMPLETE	0x0004
#define	CONN_SCAN_SKIP			0x0008

#define	CONN_JOIN_START			0x0100
#define	CONN_JOIN_ASSOC_OK		0x0200
#define	CONN_JOIN_KEY_OK		0x0400
#define	CONN_JOIN_COMPLETE		0x0800
#define	CONN_JOIN_SKIP			0x8000

tAT_AppVar *AT_GetAppVarPtr( void );
void AT_CmdScan(char **ppBuf);
void AT_CmdJoin(char **ppBuf);
static void AT_CmdDebugCtrl(char **ppBuf);
//static void AT_ShowConfigHelp(void);
void AT_CmdReset(char **ppBuf);
void AT_CmdBypass(char **ppBuf);
void AT_CmdSocketOpen(char **ppBuf);
void AT_CmdSocketClose(char **ppBuf);
static void AT_CmdShowTaskStat(char **ppBuf);
static void AT_CmdReadData(char **ppBuf);
static void AT_CmdHostEvent(char **ppBuf);
static void AT_CmdBuildVersion(char **ppBuf);
void AT_CmdUnjoin(char **ppBuf);
static void AT_CmdVersion(char **ppBuf);
static void AT_CmdCPtest(char **ppBuf);
static void AT_CmdCPgetsig(char **ppBuf);
static void AT_CmdCPGetCertificate(char **ppBuf);
#ifdef FCC
void AT_CmdTestModule(char **ppBuf);//by cbq 20241024
#endif
void AT_CmdStatus(char **ppBuf);
void AT_CmdReport(char **ppBuf);
void AT_CmdShowCpu(char **ppBuf);
void AT_CmdRcvTest(char **ppBuf);
void AT_CmdSndTest(char **ppBuf);
void AT_CmdTest(char **ppBuf);
void AT_CmdSetRate(char **ppBuf);
void AT_CmdDebugFrame(char **ppBuf);
void AT_CmdShowPool(char **ppBuf);
void AT_CmdI2S(char **ppBuf);
#ifdef DEBUG_MEM_ALLOCATIONS
void AT_CmdMemTest(char **ppBuf);
#endif
#ifdef HOSTAPD
void AT_CmdShowFS(char **ppBuf);
#endif
void AT_CmdBeacon(char **ppBuf);
void AT_CmdFactoryInit(char **ppBuf);
void AT_ShowConfigVars(uint8_t *respose);
static void AT_ListConfigVars(void);
bool isvarchar(char ch);
void AT_CmdShowBT(char **ppBuf);
void AT_CmdShowFD(char **ppBuf);
void AT_CmdShowCfg(char **ppBuf);
void AT_CmdShowFiles(char **ppBuf);
void AT_CmdConfig(char **ppBuf);
void AT_CmdShowVersion(char **ppBuf);
u8 AT_SearchParams(char *string, char **params);
void AT_SearchAndExecuteCommand(void);
void AT_CollectCommandString(u8 *pData, u16 RxLen);
void AT_ProcessHostDataInBypass(uint8 *pData, uint16 RxLen);
void AT_CmdGetMACAddress(char **ppBuf);
void AT_CmdSetMACAddress(char **ppBuf);
void vUDPRxTask( void *pvParameters );
void vTCPServerTask( void *pvParameters );
void vTCPRxTask( void *pvParameters );
void vTCPRxMPTask( void *pvParameters );
void AT_CmdShowConnection(char **ppBuf);
void AT_CmdShowMem(char **ppBuf);
void AT_CmdShowNetwork(char **ppBuf);
void AT_CmdShowDevice(char **ppBuf);
void AT_CmdShowMusicBuf(char **ppBuf);
void AT_CmdFlashloaderStart(char **ppBuf);
void MP_SendPacket(void *pData, uint16 RxLen, bool timeout);
void MP_SendPacketComplete(void *pdata, uint16 len);
void AT_CmdRemoteCmdOpen(char **ppBuf);
void AT_CmdRemoteCmdClose(char **ppBuf);
void udp_server_task(void *arg);
#endif // _AT_CMD_H_