/*******************************************************************************
* Project:      Amped'RF WIFI
* File name:    AT_Config.h
* Description:  Configuration settings
*
* Copyright (c) 2014 Amped'RF Inc., AR Technology  All rights reserved.
*******************************************************************************/
#ifndef AT_CONFIG_H
#define AT_CONFIG_H

#include "AT_Common.h"
#include "TM_FlashManager.h"
#include "TM_Device.h"
//#include "TM_UARTDriver.h"


//------------------------------------------------------------------------------
//  Build
//------------------------------------------------------------------------------
#define CFG_BUILD_NUMBER     001        // Change this to the Build number
#define CFG_BUILD_COMMENT    "AmpSerial v1.0"
                                        //   "for Hari with Prbmux = 3008"
#define CFG_BUILD_TIME  __DATE__ " " __TIME__
#define CFG_COPYRIGHT "Copyright (c) 2015 Amp'ed RF, Inc"


//  Flash DataBase Data record IDs
#define TMFM_1ST_CONFIG_ID  0x1001  // 1st config variable ID
#define TMFM_1ST_DYNAMIC_ID 0x2001  // Dynamic only record ID base
#define TMFM_1ST_CUSTOM_ID  0x3001  // Custom record ID base
#define TMFM_1ST_USER_ID    0x4001  // User record ID base

// Flash Manager
enum {
    TM_FLASH_MODEM_DB_INIT = TMFM_1ST_USER_ID,

	TM_FLASH_PSK,
    TM_FLASH_LAST_USER_ID
};

/***************************************
* Define Dynamic Config constants here *
****************************************/
#define CONFIG_MAX_VARNAME_SIZE 24  // Max size of config name variables

#define CONFIG_ATTR_HIDE     0x80   // hide variable
#define CONFIG_ATTR_HEX      0x40   // display as hex
#define CONFIG_ATTR_RO       0x20   // read only
#define CONFIG_ATTR_MASK     0x1F   // mask
enum {
    CONFIG_TYPE_STRING=0,
    CONFIG_TYPE_BOOL,
    CONFIG_TYPE_UINT8,
    CONFIG_TYPE_UINT16,
    CONFIG_TYPE_UINT32,
    CONFIG_TYPE_MACADDR,
    CONFIG_TYPE_BAUDRATE,
	CONFIG_TYPE_PARITY, 	// none, odd, even
	CONFIG_TYPE_DATABITS,	// 7p, 8, 8p. 8w, 9
	CONFIG_TYPE_STOPBITS,	// .5, 1, 1.5, 2
    CONFIG_TYPE_UINT4,      // 0 - 15
    CONFIG_TYPE_IPADDR,
    CONFIG_TYPE_GPIO,       // none, 0-15
    CONFIG_TYPE_MASTER_SLAVE,
	//CONFIG_TYPE_SSID,
	CONFIG_TYPE_AUTHTYPE,
	CONFIG_TYPE_IPPROTOCOL,
    CONFIG_TYPE_CPU_MHZ,
    CONFIG_TYPE_SPI_PRESCALER,
    CONFIG_TYPE_OUTMTUSIZE,
	CONFIG_TYPE_DEVICEMODE,
	CONFIG_TYPE_AP_INACTIVE,
	CONFIG_TYPE_AUDIOMODE,
    CONFIG_TYPE_NUM,
    CONFIG_TYPE_VOLUME,
    CONFIG_TYPE_REC_MST_VOL,
    CONFIG_TYPE_REC_PGA_VOL,
    CONFIG_TYPE_IP6ADDR,
    CONFIG_TYPE_WORKMODE,
    CONFIG_MQTT_AUTHTYPE,
    CONFIG_MQTT_QoS,
    CONFIG_TYPE_TZONE,
};

//------------------------------------------------------------------
// Protocol parameter configuration attribute.
//------------------------------------------------------------------
typedef struct {
    u8 Hide : 1;
    u8 Hex  : 1;
    u8 RO   : 1;
    u8 Type : 5;
} tConfigAttr;

//------------------------------------------------------------------
// Protocol parameter configuration structure.
//------------------------------------------------------------------
typedef struct {
    u16   Id;
    char  *Name;
    char  *Setting;
    tConfigAttr Attr;
} tConfigVar;

extern const tConfigVar ConfigVar[];
extern uint16 ConfigVarMax;

/**********************************
* Define config variable IDs here *
***********************************/
enum {
    VAR_ID_BuildVersion = TMFM_1ST_CONFIG_ID,
    VAR_ID_DeviceName,
	VAR_ID_MACaddress,
    VAR_ID_APMACaddress,
//#if defined(MESH_MULTI_HOP_MAC_FILTER) 
    VAR_ID_NxtHopaddress,
//#endif
	VAR_ID_DHCPMode,
	VAR_ID_IPaddress,
	VAR_ID_Netmask,
	VAR_ID_Gateway,
    VAR_ID_SSID,
    VAR_ID_PassPhrase,
	VAR_ID_AuthType,
	VAR_ID_HostIPaddr,
	VAR_ID_IPProtocol,
	VAR_ID_HostPort,
	VAR_ID_LocalPort,
	VAR_ID_UartBaudrate,
	VAR_ID_UartParity,
	VAR_ID_UartDataBits,
	VAR_ID_UartStopBits,
	VAR_ID_UartFlowControl,
	VAR_ID_UartTimeout,
	VAR_ID_ATReply,
	VAR_ID_HostEvents,
	VAR_ID_DebugInfo,
	VAR_ID_TestMode,
    VAR_ID_Hardware,
    VAR_ID_UseDmaIsr,
    VAR_ID_CPU_MHZ,
    //VAR_ID_SpiPrescaler,
	VAR_ID_Channel,
	VAR_ID_DevMode,
	VAR_ID_OutMtuSize,
	VAR_ID_STACount,
	VAR_ID_MultipointMode,
    VAR_ID_RCC_I2S_N,
    VAR_ID_AUTO_JOIN,
    //
    VAR_ID_Kp,
    VAR_ID_Ki,
    VAR_ID_Kd,
	
	VAR_ID_HostShallowSleepEnable,
    VAR_ID_HostDeepSleepEnable,
	VAR_ID_WiFiSleepTime,
	VAR_ID_KeepLive,
	VAR_ID_Dtim,
	VAR_ID_AP_Inactive,

#if defined(AIRPLAY) && defined(DLNA_ENABLE) 
	VAR_ID_AudioMode,
#endif
	
	VAR_ID_WsmFirmware,
	VAR_ID_WsmBootloader,
	VAR_ID_WsmSdd,
	
//#if defined(RADIO_DECODER) || defined(AVS)
    VAR_ID_SrcBufSize,
    VAR_ID_SrcBufLower,
    VAR_ID_SrcBufUpper,
    VAR_ID_PcmBufSize,
    VAR_ID_PcmBufLower,
    VAR_ID_PcmBufUpper,
    VAR_ID_HostAddr,
    VAR_ID_ConfigPath,
    VAR_ID_PlaylistPath,
    VAR_ID_MediaPath,
    VAR_ID_ConfigName,
    VAR_ID_PlaylistName,
    VAR_ID_VolCtrl,
//#endif

//#if defined(AVS)
    VAR_ID_RecMstVol,
    VAR_ID_RecPgaVol,
    VAR_ID_RecTimThr,
//#endif
//Robert add for MQTT
    VAR_ID_MQTTSIP,
    VAR_ID_MQTTSPORT,  
    VAR_ID_MQTTUSRNAME,
    VAR_ID_MQTTPASSWD, 
    VAR_ID_SUBCTOP,    
    VAR_ID_PUBLTOP,    
    VAR_ID_MQTTQOS,
    VAR_ID_MQTTAUTH,

    VAR_ID_IP6LOCAL,
    VAR_ID_IP6REMOTE,

    VAR_ID_ADDRTYPE,
    VAR_ID_WORKMODE,
//add end	    
    VAR_ID_CA_CRT_FILE,
    VAR_ID_CLI_CRT_FILE,
    VAR_ID_CLI_KEY_FILE,

    VAR_ID_URLDNS1V4,
    VAR_ID_URLDNS1V6,
    VAR_ID_URLDNS2V4,
    VAR_ID_URLDNS2V6,

    VAR_ID_MESH_ID,
    VAR_ID_MESH_PassPhrase,
    VAR_ID_MESH_AuthType,

    VAR_ID_AppAutoStart,
    VAR_ID_AutoSSID,
    VAR_ID_AutoPassPhrase,

    VAR_ID_WAVE_FILE,

    VAR_ID_TIME_ZONE,
    VAR_ID_NTPSERVER_DOMAIN,
    VAR_ID_FB_CONFIG_FILE,
    VAR_ID_HTTPS_CA_FILE,
//    VAR_ID_FB_DST_DEV_TOKEN,
    VAR_ID_MQTT_GPIO_EN,
    VAR_ID_GPIO_MODES,
/* Special Note: For versions 251220 and later, when adding configuration options, 
    you can only add them after existing configuration items. 
    This is to ensure that they can be added to older versions after OTA upgrades. 
    Otherwise, the upgrade may fail and the module may not start properly.
*/
    TMFM_LAST_CONFIG_ID
};

#define VAR_ID_COUNT  (TMFM_LAST_CONFIG_ID - TMFM_1ST_CONFIG_ID)

typedef struct CPU_T {
  	u8 Mhz;
	u32 maxBuadrate;
} cpu_t;

#define TM_HOST_EVENTS              (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_HostEvents)  ?  true : false)
#define TM_TSET_MODE              	(*(uint8 *)TM_GetFlashReadPtr(VAR_ID_TestMode)  ?  true : false)
#define TM_IP_PROTOCOL              (*(char *)TM_GetFlashReadPtr(VAR_ID_IPProtocol))
#define TM_DHCP_MODE              	(*(uint8 *)TM_GetFlashReadPtr(VAR_ID_DHCPMode)  ?  true : false)
#define TM_UART_FLOWCONTROL    	    (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartFlowControl)  ?  true : false)
#define TM_UART_BAUDRATE            (*(uint32 *)TM_GetFlashReadPtr(VAR_ID_UartBaudrate))
#define TM_UART_PARITY              (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartParity))
#define TM_UART_DATA_BITS           (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartDataBits))
#define TM_UART_STOP_BITS           (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_UartStopBits))

#define TM_USE_DMA_INTERRUPTS       true // (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_UseDmaIsr)  ?  true : false)
//#define TM_SPI_PRESCALER            ((*(uint8 *)TM_GetFlashReadPtr(VAR_ID_SpiPrescaler))<<3)
#define TM_CPU_MHZ                  (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_CPU_MHZ))
#define TM_DEVICE_MODE              (*(char *)TM_GetFlashReadPtr(VAR_ID_DevMode))
#define TM_MP_MODE             		(*(uint8 *)TM_GetFlashReadPtr(VAR_ID_MultipointMode) ? true : false)
#define TM_AUTO_JOIN                (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_AUTO_JOIN)  ?  true : false)
#define TM_HOST_SHALLOW_SLEEP_ENABLE  (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_HostShallowSleepEnable) ? true : false)
#define TM_HOST_DEEP_SLEEP_ENABLE   (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_HostDeepSleepEnable) ? true : false)
#define TM_AP_MAX_INACTIVE			(*(UINT16 *)TM_GetFlashReadPtr(VAR_ID_AP_Inactive))
#define TM_AUDIO_MODE             	(*(uint8 *)TM_GetFlashReadPtr(VAR_ID_AudioMode))
#define TM_WIFI_LP_TIME             (*(uint32 *)TM_GetFlashReadPtr(VAR_ID_WiFiSleepTime))
#define TM_KEEP_ALIVE        		(*(uint8 *)TM_GetFlashReadPtr(VAR_ID_KeepLive))
#define TM_DTIM        		        (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_Dtim))
#define TM_MQTTAUTH                 (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_MQTTAUTH))
#define TM_ADDRTYPE                 (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_ADDRTYPE))
#define TM_WORKMODE                 (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_WORKMODE))
#define TM_APPSTARTUP               (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_AppAutoStart))

//#define TM_NTPSERVER                (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_NTPSERVER_DOMAIN))
#define TM_TZONE                    (*(int8_t *)TM_GetFlashReadPtr(VAR_ID_TIME_ZONE))
#define TM_FB_REG_FLAG              (*(uint8 *)TM_GetFlashReadPtr(VAR_ID_FB_REG_FLAG))

#define MAXUDPPOOLSIZE 1472
#define MAXTCPPOOLSIZE 1460

//----------------------------------------------
#if 0
#ifdef DEBUG_CONFIG_DEFAULT
#define DHCP_MODE        "true"                 // var04
#define IP_ADDRESS       "192.168.1.2"          // var05
#define IP_GATEWAY       "192.168.1.1"          // var07
#define SSID_NAME      	 "NETGEAR85"            // var08
#define PASSPHRASE       "hungrytree018"        // var09
#define AUTHTYPE     	 "1"                    // var10
#define HOST_IP_ADDR     "192.168.1.3"          // var11
#define IPPROTOCOL		 "0"                    // var12
#define DEVICE_MODE      "0"                    // var28

#elif defined(HOSTAPD)
#define DHCP_MODE        "true"                 // var04
#define IP_ADDRESS       "192.168.0.2"          // var05
#define IP_GATEWAY       "192.168.0.1"          // var07
#define SSID_NAME      	 "Amped AP"             // var08
#define PASSPHRASE       "12345678"             // var09
//#define AUTHTYPE     	 "0"                    // var10
//#define HOST_IP_ADDR     "192.168.0.10"         // var11
//#define DEVICE_MODE      "AP"                   // var28
#endif
#endif
//----------------------------------------------


/******************************************
*  Helpful Defines for config variables   *
*******************************************/
#if 0
#define CONFIG_VARS_VERSION "4.1"

#define TM_DEVICE_NAME              ((char *)TM_GetFlashReadPtr(VAR_ID_DeviceName))

#define WPAPSK          "1"
#define WPANONE         "0"

#ifndef MAC_ADDRESS
#define MAC_ADDRESS      "00043e261122"
#endif

#ifndef DHCP_MODE
#define DHCP_MODE        "true"
#endif

#ifndef IP_ADDRESS
#define IP_ADDRESS       "192.168.0.2"
#endif

#ifndef IP_NETMASK
#define IP_NETMASK       "255.255.255.0"
#endif

#ifndef IP_GATEWAY
#define IP_GATEWAY       "192.168.0.1"
#endif

#ifndef SSID_NAME
#define SSID_NAME      	 "Amped RF"
#endif

#ifndef PASSPHRASE
#define PASSPHRASE       "12345678"
#endif

#ifndef AUTHTYPE
#define AUTHTYPE     	 WPAPSK //"1"
#endif

#ifndef CHANNEL_AP
#define CHANNEL_AP     	    "1"
#endif

#ifndef DEVICE_MODE
#define DEVICE_MODE         "STA"
#endif

#ifndef CUSTOM_HOST_EVENTS
#define CUSTOM_HOST_EVENTS  "true"
#endif

#ifndef MAIN_BAUDRATE
#define MAIN_BAUDRATE		"115200"
#endif

#ifndef DEBUGINFO
#define DEBUGINFO			"0"
#endif
#ifndef TESTMODE
#define TESTMODE			"0"
#endif

#ifndef HOST_IP_ADDR
#define HOST_IP_ADDR		"192.168.0.10"
#endif

#ifndef IPPROTOCOL
#define IPPROTOCOL		    "UDP" //0-TCP Server, 1-UDP, 2-TCP Client
#endif

#ifndef HOST_PORT
#define HOST_PORT			"2015"
#endif

#ifndef LOCAL_PORT
#define LOCAL_PORT			"2015"
#endif

#ifndef AT_REPLY
#define AT_REPLY            "AT-WF "
#endif

#ifndef TM_LED_POSITIVE_LOGIC
#define TM_LED_POSITIVE_LOGIC   true
#endif

#ifndef DEFAULT_MAIN_DATA_BITS
#define DEFAULT_MAIN_DATA_BITS      "8"         // 7p, 8, 8p. 8w, 9
#endif
#ifndef DEFAULT_MAIN_PARITY
#define DEFAULT_MAIN_PARITY         "none"      // 0=none, 1=odd
#endif
#ifndef DEFAULT_MAIN_STOP_BITS
#define DEFAULT_MAIN_STOP_BITS      "1"         // .5, 1, 1.5, 2
#endif
#ifndef CUSTOM_UART_TIMEOUT
#define CUSTOM_UART_TIMEOUT         "16"        // Uart char timeout
#endif
#ifndef CUSTOM_UART_FLOW_CTRL
#define CUSTOM_UART_FLOW_CTRL       "false"
#endif

#ifndef OUT_MTU_SIZE
#ifdef ENB_BYPASS
#define OUT_MTU_SIZE       	     "1024"//"1000"
#else
#define OUT_MTU_SIZE       	     "400"
#endif
#endif

#ifndef CUSTOM_MAX_STACOUNT
#define CUSTOM_MAX_STACOUNT       	"5"
#endif

#ifndef MULTIPOINT_DEFAULT
#define MULTIPOINT_DEFAULT       	"0"
#endif

#ifndef CUSTOM_EXTLPO
#define CUSTOM_EXTLPO       			"false"
#endif

#ifndef CUSTOM_SHALLOW_SLEEP_ENABLE
#define CUSTOM_SHALLOW_SLEEP_ENABLE       			"false"
#endif

#ifndef HOST_DEEP_SLEEP
#define HOST_DEEP_SLEEP       			"false"
#endif
#define HOST_SHALLOW_SLEEP_BIT	0x01
#define HOST_DEEP_SLEEP_BIT		0x02

#ifndef C_AP_MAX_INACTIVITY
#define C_AP_MAX_INACTIVITY				"120"
#endif

#ifndef AUDIOMODE_DEFAULT
#define AUDIOMODE_DEFAULT       	"1"  // 0-DLNA; 1-Airplay
#endif

/******************************************
*             MEDIA_STREAMING             *
*******************************************/
#if defined(AIRPLAY) || defined(DLNA_ENABLE)
//#define MEDIA_STREAMING
#endif

/******************************************
*             __HARDWARE__                *
*******************************************/
#if defined(BOARD_WF41)
#define __HARDWARE__            "WF41"
#elif defined(BOARD_WF43S)
#if defined(BOARD_WF52)
#define __HARDWARE__            "WF52"
#else
#define __HARDWARE__            "WF43"
#endif
#elif defined(BOARD_WB42_DEV)
#define __HARDWARE__            "WB42_DEV"
#else
#warning Hardware Not Defined
#endif

/******************************************
*             CUSTOM_CPU_MHZ              *
*******************************************/
#ifdef MEDIA_STREAMING
#define CUSTOM_CPU_MHZ          "168"
#else
#define CUSTOM_CPU_MHZ          "84"
#endif

/******************************************
*             __OPTION__                  *
*******************************************/
#if    defined(AIRPLAY)
#define __OPTION__  "_AIRPLAY"
#elif  defined(MEDIA_STREAMING)
#define __OPTION__  "_MEDIA"
#endif

/******************************************
*             CUSTOM_HARDWARE             *
*******************************************/
#ifdef __OPTION__
#define CUSTOM_HARDWARE         __HARDWARE__ __OPTION__
#else
#define CUSTOM_HARDWARE         __HARDWARE__
#endif

#endif

#if defined(BOARD_WF43S) || defined(BOARD_WB42_DEV)
#define TM_PIO_CONNECT_LED      4
#endif

#ifdef CUSTOM_USE_SPI
#define TM_SPI_MODE                   (*(u8*)  UT_RdConfig(VAR_ID_SPIMode, &confVarSetting.intType))
#define TM_SPI_PHASE_POLARITY         (*(u8*)  UT_RdConfig(VAR_ID_SPIPhasePolarity, &confVarSetting.intType))
#define TM_GPIO_SPI_REQ               (*(u8*)  UT_RdConfig(VAR_ID_GPIO_SPIReq, &confVarSetting.intType))
#define TM_SPI_BITRATE                (*(u32*) UT_RdConfig(VAR_ID_SPIBitRate, &confVarSetting.intType))
#endif

//-------------------------------------------------
// define version for the command set
//-------------------------------------------------
#define AT_ABSERIAL_INTERFACE_VER_MAJOR         1
#define AT_ABSERIAL_INTERFACE_VER_MINOR         0


/***************************
*  IP Send Msg structure
****************************/
typedef struct {
    void *pData;
    u32 Length;
} tIPSendMsg;



/***************************
*     IP type UDP/TCP      *
****************************/
enum {
    IPTYPE_TCP=0,
    IPTYPE_UDP,
	IPTYPE_TCPCLIENT,
//	IPTYPE_UDPCLIENT
};


#endif //AT_CONFIG_H
//------------------------------------------------------------------------------
// End of AT_Config.h

