/*******************************************************************************
* Project:      Amped'RF WIFI
* File name:    AT_Common.h
* Author:       Grace
* Created:      04/10/2014
* Description:  This file is included in all files
*
* Copyright (c) 2014 Amped'RF Inc. All rights reserved.
*******************************************************************************/

#ifndef AT_COMMON_H
#define AT_COMMON_H

#include "Build_Options.h"

#include <stdio.h>
#include "ser_dbg.h"


/********************************
* Hardware abstraction includes *
*********************************/
#include <intrinsics.h>
//#include "stm32f4xx_lib.h"

//#include "custom.h"

//------------------------------------------------------------------------------
//  Macros
//------------------------------------------------------------------------------
#define TC_UNUSED(Parameter) (Parameter = Parameter)
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define TOLOWER(c)   ((c) >= 'A' && (c) <= 'Z' ? (c)-'A'+'a' : (c))
#define ABS(x)  ((x) > 0 ? (x) : -(x))
#define NOP asm(" nop\n");

//------------------------------------------------------------------------------
//  Types
//------------------------------------------------------------------------------
/*
typedef unsigned char      uint8;
typedef unsigned short int uint16;
typedef unsigned int       uint32;
typedef unsigned long long uint64;
typedef signed char        sint8;
typedef signed short int   sint16;
typedef signed int         sint32;
typedef signed long long   sint64;
typedef char               shortbool;
#define zero64  ((uint64)0)
*/
#define MAC_ADDRESS_MAX   3

#define MAC_LEN 		  6
typedef uint8 Macaddr[MAC_LEN];

// __inline is speical function declaration in ARM compiler for
// inline function.

#define INLINE            inline
#define IRQ               __irq

#define true  ((bool)(1))
#define false ((bool)(0))
#define LINK_KEY_SIZE 16


typedef struct tBufferHeader {
  uint8  *pData;            // This must match tSysBufHdr structure
  uint32 Transac;           // This must match tSysBufHdr structure
}tBufferHeader;

typedef struct tSysBufHdr
{
  uint8               *pData;  // This must match tBufferHeader structure
  uint32              Transac; // This must match tBufferHeader structure
  struct tSysBufHdr   *pNext;
//  tSysCallBack        CallBack;
  uint16              DataLen;
}tSysBufHdr;

//------------------------------------------------------------------------------
// Multipoint data
//------------------------------------------------------------------------------
#define  MP_STATE_NEW_PACKET            0
#define  MP_STATE_LENGTH         		1
#define  MP_STATE_DATA                  2
#define  MP_HEADER_SIZE                 5

typedef struct {
    uint8     MP_State;
    uint8     *pMPbuf;
    uint16    temp_len;
    uint8     temp_len_digit_count;
    uint16    temp_data_digit_count;
} tMPState;


#define BUFFER_HEADER_SIZE           sizeof(tBufferHeader)
#define GET_BUFFER_DATA_POINTER(p)   ((uint8*)p+BUFFER_HEADER_SIZE)

#define STREAM_UINT8(ptr, data)      {*ptr++ = (data);}
#define STREAM_UINT16(ptr, data)     {*ptr++ = (uint8)((data) & 0xFF); *ptr++ = (uint8)((data) >> 8);}
#define STREAM_UINT32(ptr, data)     {*ptr++ = (uint8)((data) & 0xFF); *ptr++ = (uint8)(((data) >> 8) & 0xFF); \
                                      *ptr++ = (uint8)(((data) >> 16) & 0xFF); *ptr++ = (uint8)(((data) >> 24) & 0xFF);}

#define UNSTREAM_UINT8(ptr, data)    {(data) = (uint8)*ptr++;}
#define UNSTREAM_UINT16(ptr, data)   {(data) = (uint16)(((uint8)*ptr) | (((uint8)*(ptr+1)) << 8)); ptr += 2;}
#define UNSTREAM_UINT32(ptr, data)   {(data) = (uint32)(((uint8)*ptr) | ((uint32)((uint8)*(ptr+1)) << 8) | \
                                               ((uint32)((uint8)*(ptr+2)) << 16) | ((uint32)((uint8)*(ptr+3)) << 24)); ptr += 4;}


#define GET_COMPONENT_OFFSET(type, memb1, memb2) (uint8)(( \
                                                  ((size_t) &((type *)0)->memb1) \
                                                 -((size_t) &((type *)0)->memb2)))

#define TM_CPU_ReadCPSRMode()                   __get_interrupt_state()
#define TM_CPU_WriteCPSRControlMode(intFlags)   __set_interrupt_state(intFlags)
#define TM_CPU_WriteFIQIRQMode(intFlags)        __set_interrupt_state(intFlags)
#define TM_CPU_DisableFIQIRQMode()              __get_interrupt_state(); __disable_interrupt()
#define EIC_IRQConfig(x)                        x==DISABLE ? __disable_interrupt() : __enable_interrupt()
#define TM_CPU_DisableIRQMode()                 __get_interrupt_state(); __disable_interrupt()


//#define ENTER_CRITICAL()        uint32 TM_ICR = TM_CPU_DisableIRQMode();
//#define RE_ENTER_CRITICAL()     TM_ICR = TM_CPU_DisableIRQMode();
//#define EXIT_CRITICAL()         __set_interrupt_state(TM_ICR);

#define GKI_getbuf(sz)   os_malloc(sz) //pvSysMalloc(sz)
#define GKI_freebuf(m)   os_free(m) //vSysFree(m)


//--------------------------------------------------------------------------
//           Cortex M3
//--------------------------------------------------------------------------
#ifdef AAAAAA
void  GPIO_Config(GPIO_TypeDef* GPIOx, uint16 bits, GPIOMode_TypeDef mode);
void  GPIO_BitWrite(GPIO_TypeDef* GPIOx, uint16 pin, uint8 val);
uint8 GPIO_BitRead(GPIO_TypeDef* GPIOx, uint16 pin);
#endif
#define UART_Errors     (USART_FLAG_ORE | USART_FLAG_FE | USART_FLAG_PE)

#define UART_BUF_SIZE     1400


//--------------------------------------------------------------------------

#endif //AT_COMMON_H
//------------------------------------------------------------------------------
// End of AT_Common.h
