/***************************************************************************************************
 *                              MCU ACH118X driver library
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     flash.h
 * @brief    FLASH driver for MD25D80.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __FLASH_H
#define __FLASH_H

#include "ach118x_spi.h"
#include "GKI_spi.h"

// defines
#define FLASH_CMD_WRITE_ENABLE                  (0x06)
#define FLASH_CMD_WRITE_DISABLE                 (0x04)
#define FLASH_CMD_READ_STATUS_REGISTER          (0x05)
#define FLASH_CMD_WRITE_STATUS_REGISTER         (0x01)
#define FLASH_CMD_READ_DATA_BYTES               (0x03)
#define FLASH_CMD_READ_DATA_BYTES_HIGH          (0x0B)
#define FLASH_CMD_DAUL_OUTPUT_FAST_READ         (0x3B)
#define FLASH_CMD_PAGE_PROGRAM                  (0x02)
#define FLASH_CMD_FAST_PAGE_PROGRAM             (0xF2)
#define FLASH_CMD_SECTOR_ERASE                  (0x20)
#define FLASH_CMD_32K_BLOCK_ERASE               (0x52)
#define FLASH_CMD_64K_BLOCK_ERASE               (0xD8)
#define FLASH_CMD_CHIP_ERASE                    (0x60)//or 0xC7
#define FLASH_CMD_DEEP_POWER_DOWN               (0xB9)
#define FLASH_CMD_RELEASE_POWER_DOWN            (0xAB)
#define FLASH_CMD_READ_DEVICE_ID                (0xAB)
#define FLASH_CMD_READ_MANUFACTURE_ID           (0x90)
#define FLASH_CMD_READ_IDENTIFIACATION          (0x9F)
#define FLASH_STATUS_WIP_bit                    (0x01)
#define FLASH_STATUS_WEL_bit                    (0x02)
//#define FLASH_STATUS_BP123_bit  (0x1C)
//#define FLASH_STATUS_SRP_bit    (0x80)
#define FLASH_PAGE_SIZE                         (0x100)
#define FLASH_SECTOR_SIZE                       (0x1000)

#define PRINT_MEM_DATA(a,b,c)
#define PRINT(x)

extern SpiCtrlInfo_t xFlashSpiCtrlInfo;

void FLASH_SpiInit(void);
//void FLASH_SpiRdWr(SpiCtrlInfo_t *info, uint8_t *ptr, uint32_t payload);
void FLASH_ReadDeviceID(uint8_t *pBuf);
void FLASH_ReadManufactureID(uint8_t *pBuf);
void FLASH_ReadIdentification(uint8_t *pBuf);
void FLASH_ReadStatusRegister(uint8_t *pBuf);
void FLASH_WriteEnable(void);
void FLASH_WriteDisable(void);
void FLASH_WriteStatusRegister(uint8_t status);
static void FLASH_WaitWriteInProgressCompleted(void);
void FLASH_SectorErase(uint32_t addr);
void FLASH_32KB_BlockErase(uint32_t addr);
void FLASH_64KB_BlockErase(uint32_t addr);
void FLASH_ChipErase(void);
void FLASH_PPWriteData(uint32_t addr, uint8_t *pBuf, uint16_t len);
void FLASH_Read(uint32_t addr, uint8_t *pBuf, uint32_t len);
void FLASH_FastReadData(uint32_t addr, uint8_t *pBuf, uint32_t len);
void FLASH_EraseBySector(uint32_t start_addr, uint32_t len);
void FLASH_Write(uint32_t addr, uint8_t *pBuf, uint32_t len);
void FLASH_Erase(uint32_t addr, uint32_t len);
void FLASH_UseSemaphore(uint32_t);

#endif // __FLASH_H

