/***************************************************************************************************
 *                          MCU ACH118X driver library
 *                  COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                             All Rights Reserved
 *
 * @file     system_ach118x.h
 * @brief    System header.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __SYSTEM_ACH_H
#define __SYSTEM_ACH_H

/****************************************************************************************
* This variable is updated in three ways:
*    1) by calling CMSIS function util_GetMainFreq()
*    2) by calling API function util_SetMainFreqMHz()
*    3) each time util_GetMainFreq() is called to configure the system clock frequency
*       Note: If you use this function to configure the system clock; then there
*             is no need to call the 2 first functions listed above, since SystemCoreClock
*             variable is updated automatically.
*****************************************************************************************/

// System Clock Frequency (Core Clock).
// Updated with SystemCoreClockUpdate()
extern uint32_t SystemCoreClock;


//------------------------------------------------------------------
// API prototypes
//------------------------------------------------------------------

/**
  * @brief  Initialize main frequency, FPU setting, vector table location
  * @retval none
  */
void  SystemInit(void);

/**
  * @brief  Update SystemCoreClock variable according to Clock Register Values
  * @retval none
  */
void  SystemCoreClockUpdate(void);


#endif // __SYSTEM_ACH_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/

