/***************************************************************************************************
 *                          MCU ACH118X driver library
 *                  COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                             All Rights Reserved
 *
 * @file     ach118x_util.h
 * @brief    Various utilities.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __ACH118X_UTIL_H
#define __ACH118X_UTIL_H


typedef struct {
    uint32_t SAMPLERATE;
    uint32_t REFDIV;
    uint32_t FBDIV;
    uint32_t POSTDIV1;
    uint32_t POSTDIV2;
    uint32_t FRAC;
    uint32_t FREQ;
} PLL_SampleRate_Table_t;
extern uint8_t PLL_SampleRate_TableSize;


//------------------------------------------------------------------
// API prototypes
//------------------------------------------------------------------

/**
  * @brief  Approximate MS wait. Uses delay loops
  * @param  ms: Milliseconds
  * @retval none
  */
void  util_waitMS(uint16_t ms);

/**
  * @brief  Wait for 16 cycles
  * @retval none
  */
void  util_waitFast(void);

/**
  * @brief  Show main CPU and audio frequency
  * @retval none
  */
void  util_ShowCPU(void);

/**
  * @brief  Get main CPU frequency
  * @retval Frequency in hertz
  */
uint32_t  util_GetMainFreq(void);

/**
  * @brief  Set main CPU frequency
  * @param  MHz: Frequency in MHz
  * @retval none
  */
void  util_SetMainFreqMHz(uint32_t MHz);

/**
  * @brief  Configure Audio I2S frequency
  * @param  SampleRate: Sample rate frequency
  * @retval none
  */
int  util_ConfigAudioI2S_SampleRate(uint32_t SampleRate);

#endif // __ACH118X_UTIL_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/

