/****************************************************************************************
 *                     MCU ACH118X driver library
 *             COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                        All Rights Reserved
 *
 * @file     ach118x_type.h
 * @brief    Type definitions.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ****************************************************************************************/
#ifndef __ACH118X_TYPE_H
#define __ACH118X_TYPE_H

#define OS_NO_C_LIB_DEFINES

#include <stdint.h>

// Types used in library
typedef int64_t  s64;
typedef int32_t  s32;
typedef int16_t  s16;
typedef int8_t   s8;

typedef int64_t const sc64;  /* Read Only */
typedef int32_t const sc32;  /* Read Only */
typedef int16_t const sc16;  /* Read Only */
typedef int8_t  const sc8;   /* Read Only */

typedef volatile int64_t      vs64;
typedef volatile signed long  vs32;
typedef volatile signed short vs16;
typedef volatile signed char  vs8;

typedef volatile int64_t      const vsc64;  /* Read Only */
typedef volatile signed long  const vsc32;  /* Read Only */
typedef volatile signed short const vsc16;  /* Read Only */
typedef volatile signed char  const vsc8;   /* Read Only */

typedef uint64_t  u64;
typedef uint32_t  u32;
typedef uint16_t  u16;
typedef uint8_t   u8;

typedef uint64_t const uc64;  /* Read Only */
typedef uint32_t const uc32;  /* Read Only */
typedef uint16_t const uc16;  /* Read Only */
typedef uint8_t  const uc8;   /* Read Only */

typedef volatile uint64_t vu64;
typedef volatile uint32_t vu32;
typedef volatile uint16_t vu16;
typedef volatile uint8_t  vu8;

typedef volatile uint64_t const vuc64;  /* Read Only */
typedef volatile uint32_t const vuc32;  /* Read Only */
typedef volatile uint16_t const vuc16;  /* Read Only */
typedef volatile uint8_t  const vuc8;   /* Read Only */

typedef uint64_t uint64;
typedef uint32_t uint32;
typedef uint16_t uint16;
typedef uint8_t  uint8;

typedef enum {FALSE = 0, TRUE = !FALSE} bool, Boolean;

typedef enum
{
  RESET = 0U,
  SET = !RESET
} FlagStatus, ITStatus;

typedef enum
{
  DISABLE = 0U,
  ENABLE = !DISABLE
} FunctionalState;
#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

typedef enum
{
  ERROR = 0U,
  SUCCESS = !ERROR
} ErrorStatus;

typedef enum
{
    LOW = 0U,
    HIGH
} LevelState;

#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif



#define SET_BIT(REG, BIT)       ((REG) |= (BIT))
#define CLEAR_BIT(REG, BIT)     ((REG) &= ~(BIT))
#define READ_BIT(REG, BIT)      ((REG) & (BIT))
#define CLEAR_REG(REG)          ((REG) = (0x0))
#define WRITE_REG(REG, VAL)     ((REG) = (VAL))
#define READ_REG(REG)           ((REG))
#define MODIFY_REG(REG, CLEARMASK, SETMASK)  WRITE_REG((REG), (((READ_REG(REG)) & (~(CLEARMASK))) | (SETMASK)))
#define POSITION_VAL(VAL)       (__CLZ(__RBIT(VAL)))
#define REG32(baseaddr, offset) *(volatile uint32_t *)((uint8_t *)baseaddr + offset)
#define REG8(baseaddr, offset)  *(volatile uint8_t *)((uint8_t *)baseaddr + offset)
#define VAL8(x)                 *(uint8_t *)&x
#define VAL16(x)                *(uint16_t *)&x

#endif // __ACH118X_TYPE_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/
