/***************************************************************************************************
 *                          MCU ACH118X driver library
 *                  COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                             All Rights Reserved
 *
 * @file     ach1180x_map.h
 * @brief    Memory mappings and structure of peripherals.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __ACH1180X_MAP_H
#define __ACH1180X_MAP_H

#include "ach118x_device.h"

// APB0_PERIPH_BASE
#define I2S0            ((I2S_Typedef *) I2S0_REG_BASE)         // 0x4002 2800
#define I2S1            ((I2S_Typedef *) I2S1_REG_BASE)         // 0x4002 4000
#define UART0           ((UART_Typedef *) UART0_REG_BASE)       // 0x4002 3000
#define UART1           ((UART_Typedef *) UART1_REG_BASE)       // 0x4002 3800
#define UART2           ((UART_Typedef *) UART2_REG_BASE)       // 0x4002 6000
#define I2C             ((I2C_Typedef *)  I2C0_REG_BASE)        // 0x4002 5000
#define ADC0            (ADC_Typedef *) (ADC0_REG_BASE | 0xD0)  // 0x4003 38D0
#define ADC1            (ADC_Typedef *) (ADC1_REG_BASE | 0xF0)  // 0x4003 40F0
#define AES				((AES_TypeDef *) (AES_REG_BASE + 0x54))
#define SPI0            ((SPI_Typedef *) SPI0_REG_BASE)         // 0x4002 1800
#define SPI1            ((SPI_Typedef *) SPI1_REG_BASE)         // 0x4002 2200
#define SPI2            ((SPI_Typedef *) SPI2_REG_BASE)         // 0x4002 4800
#define TIM0            ((TIM_Typedef *) TIM0_REG_BASE)
#define TIM1            ((TIM_Typedef *) TIM1_REG_BASE)
#define TIM2            ((TIM_Typedef *) TIM2_REG_BASE)
#define TIM3            ((TIM_Typedef *) TIM3_REG_BASE)
#define EXTI            ((GPIO_IntTypeDef*) GPIO_INT_BASE)
// APB1_PERIPH_BASE
#define SYS             ((SYS_Typedef *) SYSCFG_REG_BASE)       // 0x4003 5800
#define SYSCFG          ((SYS_Typedef *) SYSCFG_REG_BASE)       // 0x4003 5800
#define SYSCFG_BASE     SYSCFG_REG_BASE                         // 0x4003 5800
#define GPIO_BASE       GPIO3_REG_BASE                          // 0x4003 1800

#define SYS_RESET        (*(uint32_t *)&SYS->RESET)
#define SYS_INT_MASK     (*(uint32_t *)&SYS->INT_MASK)
#define SYS_INT_STATUS   (*(uint32_t *)&SYS->INT_STATUS)
#define SYS_INT_POLARITY (*(uint32_t *)&SYS->INT_POLARITY)


// APB1_PERIPH_BASE GPIO
#define GPIO            ((APB_GPIO_Typedef *)GPIO3_REG_BASE)    // 0x4003 1800
#define GPIOA_BASE      ((APB1_PERIPH_BASE | 0x1800))           // 0x4003 1800
#define GPIOB_BASE      ((APB1_PERIPH_BASE | 0x180C))           // 0x4003 180C
#define GPIOC_BASE      ((APB1_PERIPH_BASE | 0x1818))           // 0x4003 1818
#define GPIOD_BASE      ((APB1_PERIPH_BASE | 0x1824))           // 0x4003 1824
#define GPIOA           ((GPIO_Typedef *) GPIOA_BASE)           // 0x4003 1800
#define GPIOB           ((GPIO_Typedef *) GPIOB_BASE)           // 0x4003 180C
#define GPIOC           ((GPIO_Typedef *) GPIOC_BASE)           // 0x4003 1818
#define GPIOD           ((GPIO_Typedef *) GPIOD_BASE)           // 0x4003 1824

// AHB_PERIPH_BASE
#define DMA             ((DMA_Typedef *)         DMA_REG_BASE)
#define DMA_CHANNEL0    ((DMA_Channel_Typedef *) DMA_CHANNEL0_BASE)
#define DMA_CHANNEL1    ((DMA_Channel_Typedef *) DMA_CHANNEL1_BASE)
#define DMA_CHANNEL2    ((DMA_Channel_Typedef *) DMA_CHANNEL2_BASE)
#define DMA_CHANNEL3    ((DMA_Channel_Typedef *) DMA_CHANNEL3_BASE)
#define DMA_CHANNEL4    ((DMA_Channel_Typedef *) DMA_CHANNEL4_BASE)
#define DMA_CHANNEL5    ((DMA_Channel_Typedef *) DMA_CHANNEL5_BASE)
#define DMA_CHANNEL6    ((DMA_Channel_Typedef *) DMA_CHANNEL6_BASE)
#define DMA_CHANNEL7    ((DMA_Channel_Typedef *) DMA_CHANNEL7_BASE)
#define DMA_PARAM       ((DMA_Param_Typedef *)   DMA_PARAM_BASE)


#define WDT             ((WDT_Typedef *) WDT_REG_BASE)
// Convenient references
#define EXT_I2S         I2S0                                    // 0x4002 2800
#define AUDIO_I2S       I2S1                                    // 0x4002 4000
#define MAIN_UART       UART0                                   // 0x4002 3000

#endif // __ACH1180X_MAP_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/

