/***************************************************************************************************
 *                          MCU ACH118X driver library
 *                  COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                             All Rights Reserved
 *
 * @file     ach118x_it.h
 * @brief    Vector headers - weakly defined instantiations in startup_ach11x.s.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __ACH118X_IT_H
#define __ACH118X_IT_H

void NMI_Handler(void);
void HardFault_Handler(void);
void MemManage_Handler(void);
void BusFault_Handler(void);
void UsageFault_Handler(void);
void SVC_Handler(void);
void DebugMon_Handler(void);
void PendSV_Handler(void);
void SysTick_Handler(void);

// Device Handlers
void IGPIO_IRQHandler(void);
void SPI0_IRQHandler(void);
void SPI1_IRQHandler(void);
void SPI2_IRQHandler(void);
void I2S0_IRQHandler(void);
void UART0_IRQHandler(void);
void UART1_IRQHandler(void);
void UART2_IRQHandler(void);
void I2S1_IRQHandler(void);
void I2C_IRQHandler(void);
void TIM0_IRQHandler(void);
void GPIO_IRQHandler(void);
void WDT_IRQHandler(void);
void ADC0_IRQHandler(void);
void ADC1_IRQHandler(void);
void AES_IRQHandler(void);
void DMA_IRQHandler(void);
void TIM1_IRQHandler(void);
void TIM2_IRQHandler(void);
void TIM3_IRQHandler(void);

typedef struct{
    void (*Spi0IrqFun)(void);
    void (*Spi1IrqFun)(void);
    void (*Spi2IrqFun)(void);
    void (*I2s0IrqFun)(void);
    void (*Uart0IrqFun)(void);
    void (*Uart1IrqFun)(void);
    void (*Uart2IrqFun)(void);
    void (*I2s1IrqFun)(void);
    void (*I2cIrqFun)(void);
    void (*Tim0IrqFun)(void);
    void (*Tim1IrqFun)(void);
    void (*Tim2IrqFun)(void);
    void (*Tim3IrqFun)(void);
    void (*GpioIrqFun)(void);
    void (*WdtIrqFun)(void);
    void (*Adc0IrqFun)(void);
    void (*Adc1IrqFun)(void);
    void (*AesIrqFun)(void);
    void (*DmaIrqFun)(void);
}IrqFunType;
typedef enum{
    SPI0IRQ = 0,
    SPI1IRQ,
    SPI2IRQ,
    I2S0IRQ,
    UART0IRQ,
    UART1IRQ,
    UART2IRQ,
    I2S1IRQ,
    I2CIRQ,
    TIM0IRQ,
    TIM1IRQ,
    TIM2IRQ,
    TIM3IRQ,
    GPIOIRQ,
    WDTIRQ,
    ADC0IRQ,
    ADC1IRQ,
    AESIRQ,
    DMAIRQ
}IrqType;

//------------------------------------------------------------------
// API prototypes
//------------------------------------------------------------------
void RegisterIrqFunction(void (*pFun)(void),IrqType Type);

#endif // __ACH118X_IT_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/

