/***************************************************************************************************
 *                              MCU ACH118X driver library
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     ach118x_gpio.h
 * @brief    Functions prototypes for the GPIO.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __ACH118X_GPIO_H
#define __ACH118X_GPIO_H

#include "ach118x_type.h"

//System config registers output enable register address
//System config register26 output enable register0 address
#define SYSCFG_REG26_OUTPUTENABLE_REG0_ADDR     (SYSCFG_BASE + 0x6C)
//System config register27 output enable register1 address
#define SYSCFG_REG27_OUTPUTENABLE_REG1_ADDR     (SYSCFG_BASE + 0x70)

//System config registers output enable register
//System config register26 output enable register0
#define SYSCFG_REG26_OUTPUTENABLE_REG0          *(uint32_t*)SYSCFG_REG26_OUTPUTENABLE_REG0_ADDR
//System config register27 output enable register1
#define SYSCFG_REG27_OUTPUTENABLE_REG1          *(uint32_t*)SYSCFG_REG27_OUTPUTENABLE_REG1_ADDR

//User GPIO gpio_ext_porta register address
#define GPIO_EXT_PORTA_REG        *(uint32_t*)(GPIOA_BASE + 0x50)
//User GPIO gpio_ext_portb register address
#define GPIO_EXT_PORTB_REG        *(uint32_t*)(GPIOA_BASE + 0x54)
//User GPIO gpio_ext_portc register address
#define GPIO_EXT_PORTC_REG        *(uint32_t*)(GPIOA_BASE + 0x58)

/**gpio_swport_dr Bit**/
#define GPIO_SWPORT_DR_BIT0_SHIFT  (0)
#define GPIO_SWPORT_DR_BIT0_MASK   (1 << GPIO_SWPORT_DR_BIT0_SHIFT)
#define GPIO_SWPORT_DR_BIT1_SHIFT  (1)
#define GPIO_SWPORT_DR_BIT1_MASK   (1 << GPIO_SWPORT_DR_BIT1_SHIFT)
#define GPIO_SWPORT_DR_BIT2_SHIFT  (2)
#define GPIO_SWPORT_DR_BIT2_MASK   (1 << GPIO_SWPORT_DR_BIT2_SHIFT)
#define GPIO_SWPORT_DR_BIT3_SHIFT  (3)
#define GPIO_SWPORT_DR_BIT3_MASK   (1 << GPIO_SWPORT_DR_BIT3_SHIFT)

/**gpio_swport_ddr Bit**/
#define GPIO_SWPORT_DDR_BIT0_SHIFT  (0)
#define GPIO_SWPORT_DDR_BIT0_MASK   (1 << GPIO_SWPORT_DDR_BIT0_SHIFT)
#define GPIO_SWPORT_DDR_BIT1_SHIFT  (1)
#define GPIO_SWPORT_DDR_BIT1_MASK   (1 << GPIO_SWPORT_DDR_BIT1_SHIFT)
#define GPIO_SWPORT_DDR_BIT2_SHIFT  (2)
#define GPIO_SWPORT_DDR_BIT2_MASK   (1 << GPIO_SWPORT_DDR_BIT2_SHIFT)
#define GPIO_SWPORT_DDR_BIT3_SHIFT  (3)
#define GPIO_SWPORT_DDR_BIT3_MASK   (1 << GPIO_SWPORT_DDR_BIT3_SHIFT)
typedef enum
{
    GPIO_PIN_INPUT = 0,
    GPIO_PIN_OUTPUT = 1,
} GPIO_MODE;
/*
typedef struct
{
    vu32    DR;    //0x00, GPIO data register
    vu32    DDR;   //0x04, GPIO data direction register
    vu32    CTRL;   //0x08, GPIO control register
} GPIO_TypeDef;
*/
typedef enum
{
    Pin_0 = 0x01,
    Pin_1 = 0x02,
    Pin_2 = 0x04,
    Pin_3 = 0x08,
    Pin_All = 0x0f
} GPIO_Pin;
typedef enum
{
    INPUT_Float = 0,
    //INPUT_Up,
    //INPUT_Down,
    OUTPUT,
} GPIO_Mode;

/**gpio_swport_ctl**/
#define GPIO_SWPORT_CTL_DATASRC_BIT_SHIFT   (0)
#define GPIO_SWPORT_CTL_DATASRC_BIT_MASK    (1 << GPIO_SWPORT_CTL_DATASRC_BIT_SHIFT)
typedef enum
{
    GPIO_SOFTWAREMODE = 0,
    GPIO_HARDWAREMODE = 1,
} GPIO_DATASRC;

/**gpio_inten Bit**/
#define GPIO_INTEN_BIT0_SHIFT  (0)
#define GPIO_INTEN_BIT0_MASK   (1 << GPIO_INTEN_BIT0_SHIFT)
#define GPIO_INTEN_BIT1_SHIFT  (1)
#define GPIO_INTEN_BIT1_MASK   (1 << GPIO_INTEN_BIT1_SHIFT)
#define GPIO_INTEN_BIT2_SHIFT  (2)
#define GPIO_INTEN_BIT2_MASK   (1 << GPIO_INTEN_BIT2_SHIFT)
#define GPIO_INTEN_BIT3_SHIFT  (3)
#define GPIO_INTEN_BIT3_MASK   (1 << GPIO_INTEN_BIT3_SHIFT)
typedef enum
{
    GPIO_INT_DISABLE = 0,
    GPIO_INT_ENABLE = 1,
} GPIO_INT;

/**gpio_intmask Bit**/
#define GPIO_INTMASK_BIT0_SHIFT  (0)
#define GPIO_INTMASK_BIT0_MASK   (1 << GPIO_INTMASK_BIT0_SHIFT)
#define GPIO_INTMASK_BIT1_SHIFT  (1)
#define GPIO_INTMASK_BIT1_MASK   (1 << GPIO_INTMASK_BIT1_SHIFT)
#define GPIO_INTMASK_BIT2_SHIFT  (2)
#define GPIO_INTMASK_BIT2_MASK   (1 << GPIO_INTMASK_BIT2_SHIFT)
#define GPIO_INTMASK_BIT3_SHIFT  (3)
#define GPIO_INTMASK_BIT3_MASK   (1 << GPIO_INTMASK_BIT3_SHIFT)
typedef enum
{
    GPIO_INT_UNMASKED = 0,
    GPIO_INT_MASKED = 1,
} GPIO_INTMASK;

/**gpio_inttype_level Bit**/
#define GPIO_INTTYPELV_BIT0_SHIFT  (0)
#define GPIO_INTTYPELV_BIT0_MASK   (1 << GPIO_INTTYPELV_BIT0_SHIFT)
#define GPIO_INTTYPELV_BIT1_SHIFT  (1)
#define GPIO_INTTYPELV_BIT1_MASK   (1 << GPIO_INTTYPELV_BIT1_SHIFT)
#define GPIO_INTTYPELV_BIT2_SHIFT  (2)
#define GPIO_INTTYPELV_BIT2_MASK   (1 << GPIO_INTTYPELV_BIT2_SHIFT)
#define GPIO_INTTYPELV_BIT3_SHIFT  (3)
#define GPIO_INTTYPELV_BIT3_MASK   (1 << GPIO_INTTYPELV_BIT3_SHIFT)
typedef enum
{
    GPIO_INT_LEVELSENSITIVE = 0,
    GPIO_INT_EDGESENSITIVE = 1,
} GPIO_INTTYPELV;

/**gpio_int_polarity Bit**/
#define GPIO_INTPOLARITY_BIT0_SHIFT  (0)
#define GPIO_INTPOLARITY_BIT0_MASK   (1 << GPIO_INTPOLARITY_BIT0_SHIFT)
#define GPIO_INTPOLARITY_BIT1_SHIFT  (1)
#define GPIO_INTPOLARITY_BIT1_MASK   (1 << GPIO_INTPOLARITY_BIT1_SHIFT)
#define GPIO_INTPOLARITY_BIT2_SHIFT  (2)
#define GPIO_INTPOLARITY_BIT2_MASK   (1 << GPIO_INTPOLARITY_BIT2_SHIFT)
#define GPIO_INTPOLARITY_BIT3_SHIFT  (3)
#define GPIO_INTPOLARITY_BIT3_MASK   (1 << GPIO_INTPOLARITY_BIT3_SHIFT)
typedef enum
{
    GPIO_INT_ACTIVELOW = 0,
    GPIO_INT_ACTIVEHIGH = 1,
} GPIO_INTPOLARITY;

/**gpio_intstatus Bit**/
#define GPIO_INTSTATUS_BIT0_SHIFT  (0)
#define GPIO_INTSTATUS_BIT0_MASK   (1 << GPIO_INTSTATUS_BIT0_SHIFT)
#define GPIO_INTSTATUS_BIT1_SHIFT  (1)
#define GPIO_INTSTATUS_BIT1_MASK   (1 << GPIO_INTSTATUS_BIT1_SHIFT)
#define GPIO_INTSTATUS_BIT2_SHIFT  (2)
#define GPIO_INTSTATUS_BIT2_MASK   (1 << GPIO_INTSTATUS_BIT2_SHIFT)
#define GPIO_INTSTATUS_BIT3_SHIFT  (3)
#define GPIO_INTSTATUS_BIT3_MASK   (1 << GPIO_INTSTATUS_BIT3_SHIFT)
typedef enum
{
    GPIO_INT_UNTRIGGERED = 0,
    GPIO_INT_TRIGGERED = 1,
} GPIO_INTSTATUS;

/**gpio_raw_intstatus Bit**/
#define GPIO_RAWINTSTATUS_BIT0_SHIFT  (0)
#define GPIO_RAWINTSTATUS_BIT0_MASK   (1 << GPIO_RAWINTSTATUS_BIT0_SHIFT)
#define GPIO_RAWINTSTATUS_BIT1_SHIFT  (1)
#define GPIO_RAWINTSTATUS_BIT1_MASK   (1 << GPIO_RAWINTSTATUS_BIT1_SHIFT)
#define GPIO_RAWINTSTATUS_BIT2_SHIFT  (2)
#define GPIO_RAWINTSTATUS_BIT2_MASK   (1 << GPIO_RAWINTSTATUS_BIT2_SHIFT)
#define GPIO_RAWINTSTATUS_BIT3_SHIFT  (3)
#define GPIO_RAWINTSTATUS_BIT3_MASK   (1 << GPIO_RAWINTSTATUS_BIT3_SHIFT)
typedef enum
{
    GPIO_RAWINT_UNTRIGGERED = 0,
    GPIO_RAWINT_TRIGGERED = 1,
} GPIO_RAWINTSTATUS;

/**gpio_debounce Bit**/
#define GPIO_DEBOUNCE_BIT0_SHIFT  (0)
#define GPIO_DEBOUNCE_BIT0_MASK   (1 << GPIO_DEBOUNCE_BIT0_SHIFT)
#define GPIO_DEBOUNCE_BIT1_SHIFT  (1)
#define GPIO_DEBOUNCE_BIT1_MASK   (1 << GPIO_DEBOUNCE_BIT1_SHIFT)
#define GPIO_DEBOUNCE_BIT2_SHIFT  (2)
#define GPIO_DEBOUNCE_BIT2_MASK   (1 << GPIO_DEBOUNCE_BIT2_SHIFT)
#define GPIO_DEBOUNCE_BIT3_SHIFT  (3)
#define GPIO_DEBOUNCE_BIT3_MASK   (1 << GPIO_DEBOUNCE_BIT3_SHIFT)
typedef enum
{
    GPIO_DEBOUNCE_DISABLE = 0,
    GPIO_DEBOUNCE_ENABLE = 1,
} GPIO_DEBOUNCE;

/**gpio_porta_eoi Bit**/
#define GPIO_PORTAEOI_BIT0_SHIFT  (0)
#define GPIO_PORTAEOI_BIT0_MASK   (1 << GPIO_PORTAEOI_BIT0_SHIFT)
#define GPIO_PORTAEOI_BIT1_SHIFT  (1)
#define GPIO_PORTAEOI_BIT1_MASK   (1 << GPIO_PORTAEOI_BIT1_SHIFT)
#define GPIO_PORTAEOI_BIT2_SHIFT  (2)
#define GPIO_PORTAEOI_BIT2_MASK   (1 << GPIO_PORTAEOI_BIT2_SHIFT)
#define GPIO_PORTAEOI_BIT3_SHIFT  (3)
#define GPIO_PORTAEOI_BIT3_MASK   (1 << GPIO_PORTAEOI_BIT3_SHIFT)
typedef enum
{
    GPIO_NOINTCLR = 0,
    GPIO_INTCLR = 1,
} GPIO_PORTAEOI;

/**gpio_ext_port Bit**/
#define GPIO_EXTPORT_BIT0_SHIFT  (0)
#define GPIO_EXTPORT_BIT0_MASK   (1 << GPIO_EXTPORT_BIT0_SHIFT)
#define GPIO_EXTPORT_BIT1_SHIFT  (1)
#define GPIO_EXTPORT_BIT1_MASK   (1 << GPIO_EXTPORT_BIT1_SHIFT)
#define GPIO_EXTPORT_BIT2_SHIFT  (2)
#define GPIO_EXTPORT_BIT2_MASK   (1 << GPIO_EXTPORT_BIT2_SHIFT)
#define GPIO_EXTPORT_BIT3_SHIFT  (3)
#define GPIO_EXTPORT_BIT3_MASK   (1 << GPIO_EXTPORT_BIT3_SHIFT)

/**gpio_ls_sync Bit**/
#define GPIO_LSSYNC_SYNCLV_BIT_SHIFT  (0)
#define GPIO_LSSYNC_SYNCLV_BIT_MASK   (1 << GPIO_LSSYNC_SYNCLV_BIT_SHIFT)
typedef enum
{
    GPIO_NOSYNCTOPCLKINTR = 0,
    GPIO_SYNCTOPCLKINTR = 1,
} GPIO_LSSYNC_SYNCLV;

/**gpio_int_bothedge Bit**/
#define GPIO_INTBOTHEDGE_TYPE_BIT_SHIFT  (0)
#define GPIO_INTBOTHEDGE_TYPE_BIT_MASK   (1 << GPIO_INTBOTHEDGE_TYPE_BIT_SHIFT)
typedef enum
{
    GPIO_INTBOTHEDGE_ACTIVELOW = 0,
    GPIO_INTBOTHEDGE_ACTIVEHIGH = 1,
} GPIO_INTBOTHEDGE_TYPE;

/*
@brief  GPIO Init structure definition
*/
typedef struct
{
    uint32_t GPIO_Pin;
    GPIO_MODE Pin_Mode;
    FlagStatus Pin_Status;
} GPIO_InitTypeDef;

/* GPIO registers definition */
typedef struct
{
    vu32    gpio_swport_dr;    //0x00, GPIO data register
    vu32    gpio_swport_ddr;   //0x04, GPIO data direction register
    vu32    gpio_swport_ctl;   //0x08, GPIO control register
} GPIO_Typedef;

//GPIO pin definition
#define GPIO_Pin_0      ((uint32_t)0x00000001)  //Pin 0 selected
#define GPIO_Pin_1      ((uint32_t)0x00000002)  //Pin 1 selected
#define GPIO_Pin_2      ((uint32_t)0x00000004)  //Pin 2 selected
#define GPIO_Pin_3      ((uint32_t)0x00000008)  //Pin 3 selected
#define GPIO_Pin_All    ((uint32_t)0x0000000F)  //Pin all selected

/*
@brief System configuration register26 output enable register0 structure definition
*/
typedef union _sysCfgReg26OutputEnableReg0TypeDef_t
{
    vu32 regVal;
    struct
    {
        vu32 p01ChipPin    : 2 ; //Switch the function of P01
        vu32 p02ChipPin    : 2 ; //Switch the function of P02
        vu32 p03ChipPin    : 2 ; //Switch the function of P03
        vu32 p04ChipPin    : 2 ; //Switch the function of P04
        vu32 Reserved      : 8 ; //Reserved
        vu32 p09ChipPin    : 2 ; //Switch the function of P09
        vu32 p10ChipPin    : 2 ; //Switch the function of P10
        vu32 p11ChipPin    : 2 ; //Switch the function of P11
        vu32 p12ChipPin    : 2 ; //Switch the function of P12
        vu32 p13ChipPin    : 2 ; //Switch the function of P13
        vu32 p14ChipPin    : 2 ; //Switch the function of P14
        vu32 p15ChipPin    : 2 ; //Switch the function of P15
        vu32 p16ChipPin    : 2 ; //Switch the function of P16
    } bits;
} sysCfgReg26OutputEnableReg0TypeDef_t;

//System configuration register26 output enable register0 pin01 function option
#define P01FUNC_SPI0_MOSI_O                             (0x00)
#define P01FUNC_UART1_CTS_I                             (0x01)
//System configuration register26 output enable register0 pin02 function option
#define P02FUNC_SPI0_SSN_O                              (0x00)
#define P02FUNC_UART1_RTS_O                             (0x01)
//System configuration register26 output enable register0 pin03 function option
#define P03FUNC_SPI0_SCK_O                              (0x00)
#define P03FUNC_UART1_TX_O                              (0x01)
//System configuration register26 output enable register0 pin04 function option
#define P04FUNC_SPI0_MISO_I                             (0x00)
#define P04FUNC_UART1_RX_I                              (0x01)
#define P04FUNC_GPIO3_8_O                               (0x02)
//System configuration register26 output enable register0 pin09 function option
#define P09FUNC_JTDI_I                                  (0x00)
#define P09FUNC_UART2_RX_I                              (0x01)
#define P09FUNC_GPIO3_10_O                              (0x02)
#define P09FUNC_GPIO3_10_I                              (0x03)
//System configuration register26 output enable register0 pin10 function option
#define P10FUNC_JTDO_O                                  (0x00)
#define P10FUNC_UART2_TX_O                              (0x01)
#define P10FUNC_GPIO3_11_O                              (0x02)
#define P10FUNC_GPIO3_11_I                              (0x03)
//System configuration register26 output enable register0 pin11 function option
#define P11FUNC_TRSTN_I                                 (0x00)
#define P11FUNC_UART2_CTS_I                             (0x01)
#define P11FUNC_GPIO3_9_O                               (0x02)
#define P11FUNC_GPIO3_9_I                               (0x03)
//System configuration register26 output enable register0 pin12 function option
#define P12FUNC_GPIO3_0_O                               (0x00)
#define P12FUNC_UART2_RTS_O                             (0x01)
#define P12FUNC_GPIO3_0_I                               (0x02)
//System configuration register26 output enable register0 pin13 function option
#define P13FUNC_GPIO3_1_O                               (0x00)
#define P13FUNC_I2S0_WS_O                               (0x01)
#define P13FUNC_SPI1_SSN_O                              (0x02)
#define P13FUNC_GPIO3_1_I2S1_WS_SYNO_CODEC_I            (0x03)
//System configuration register26 output enable register0 pin14 function option
#define P14FUNC_GPIO3_2_O                               (0x00)
#define P14FUNC_I2S0_CLK_SEL_STAGE1_O                   (0x01)
#define P14FUNC_SPI1_SCK_O                              (0x02)
#define P14FUNC_GPIO3_2_I2S0_CLK_I2S1_CLK_SYNO_CODEC_I  (0x03)
//System configuration register26 output enable register0 pin15 function option
#define P15FUNC_GPIO3_3_O                               (0x00)
#define P15FUNC_GPIO3_3_I                               (0x01)
#define P15FUNC_SPI1_MISO_I2S0_RX_I                     (0x02)
#define P15FUNC_I2S1_RX_SYNO_CODEC_O                    (0x03)
//System configuration register26 output enable register0 pin16 function option
#define P16FUNC_GPIO3_4_O                               (0x00)
#define P16FUNC_I2S0_TX_O                               (0x01)
#define P16FUNC_SPI1_MOSI_O                             (0x02)
#define P16FUNC_GPIO3_4_I2S1_TX_SYNO_CODEC_I            (0x03)

/*
@brief System configuration register27 output enable register1 structure definition
*/
typedef union _sysCfgReg27OutputEnableReg1TypeDef_t
{
    vu32 regVal;
    struct
    {
        vu32 p17ChipPin    : 2 ; //Switch the function of P17
        vu32 Reserved0     : 12; //Reserved
        vu32 p24ChipPin    : 2 ; //Switch the function of P24
        vu32 p25ChipPin    : 2 ; //Switch the function of P25
        vu32 p26ChipPin    : 2 ; //Switch the function of P26
        vu32 p27ChipPin    : 2 ; //Switch the function of P27
        vu32 Reserved1     : 10; //Reserved
    } bits;
} sysCfgReg27OutputEnableReg1TypeDef_t;

//System configuration register27 output enable register0 pin17 function option
#define P17FUNC_GPIO3_5_O                               (0x00)
#define P17FUNC_GPIO3_5_I                               (0x01)
#define P17FUNC_MSCLK1_SYNO_CODEC_I                     (0x02)

//System configuration register27 output enable register0 pin24 function option
#define P24FUNC_GPIO3_6_O                               (0x00)
#define P24FUNC_TCK_SWCLK_I                             (0x01)
#define P24FUNC_GPIO3_6_I                               (0x02)

//System configuration register27 output enable register0 pin25 function option
#define P25FUNC_SWDIO_TMS_O                             (0x00)
#define P25FUNC_GPIO3_7_O                               (0x01)
#define P25FUNC_GPIO3_7_I                               (0x02)
#define P25FUNC_SWDIO_TMS_I                             (0x03)

//System configuration register27 output enable register0 pin26 function option
#define P26FUNC_I2C0_SDA_O                              (0x00)
#define P26FUNC_I2C0_SDA_I                              (0x01)

//System configuration register27 output enable register0 pin27 function option
#define P27FUNC_I2C0_SCL_O                              (0x00)
#define P27FUNC_I2C0_SCL_I                              (0x01)

//Chip pin serial number enum
typedef enum
{
    ChipP01 = 1,
    ChipP02 = 2,
    ChipP03 = 3,
    ChipP04 = 4,
    ChipP09 = 9,
    ChipP10 = 10,
    ChipP11 = 11,
    ChipP12 = 12,
    ChipP13 = 13,
    ChipP14 = 14,
    ChipP15 = 15,
    ChipP16 = 16,
    ChipP17 = 17,
    ChipP24 = 24,
    ChipP25 = 25,
    ChipP26 = 26,
    ChipP27 = 27,
} ChipPinNumTypeDef;



typedef struct {
    vu32
        ABD_DATA_WIDTH              : 2,
        NUM_PORTS                   : 2,
        PORTA_SINGLE_CTL            : 1,
        PORTB_SINGLE_CTL            : 1,
        PORTC_SINGLE_CTL            : 1,
        PORTD_SINGLE_CTL            : 1,
        HW_PORTA                    : 1,
        HW_PORTB                    : 1,
        HW_PORTC                    : 1,
        HW_PORTD                    : 1,
        PORTA_INTR                  : 1,
        DEBOUNCE                    : 1,
        ADD_ENCODED_PARAMS          : 1,
        GPIO_ID                     : 1,
        ENCODED_ID_WIDTH            : 5,
        INTERRUPT_BOTH_EDGE_TYPE    : 1,
        Reserved_31_32              : 2;
} APB_GPIO_CONFIG_REG1_Typedef;

typedef struct {
    vu32
        ENCODED_ID_PWIDTH_A         : 5,
        ENCODED_ID_PWIDTH_B         : 5,
        ENCODED_ID_PWIDTH_C         : 5,
        ENCODED_ID_PWIDTH_D         : 5,
        Reserved_20_31              : 12;
} APB_GPIO_CONFIG_REG2_Typedef;

typedef struct {
    vu32 swporta_dr;                // 0x00 - Port A data register
    vu32 swporta_ddr;               // 0x04 - Port A data direction register
    vu32 swporta_ctl;               // 0x08 - Port A data source register (not used)
    vu32 swportb_dr;                // 0x0c - Port B data register
    vu32 swportb_ddr;               // 0x10 - Port B data direction register
    vu32 swportb_ctl;               // 0x14 - Port B data source register (not used)
    vu32 swportc_dr;                // 0x18 - Port C data register
    vu32 swportc_ddr;               // 0x1c - Port C data direction register
    vu32 swportc_ctl;               // 0x20 - Port C data source register (not used)
    vu32 swportd_dr;                // 0x24 - Port D data register
    vu32 swportd_ddr;               // 0x28 - Port D data direction register
    vu32 swportd_ctl;               // 0x2c - Port D data source register (not used)
    vu32 inten;                     // 0x30 - Interrupt enable register
    vu32 intmask;                   // 0x34 - Interrupt mask register
    vu32 inttype_level;             // 0x38 - Interrupt level register
    vu32 int_polarity;              // 0x3c - Interrupt polarity register
    vu32 intstatus;                 // 0x40 - Interrupt status of Port A
    vu32 raw_intstatus;             // 0x44 - Raw interrupt status of Port A (premasking)
    vu32 debounce;                  // 0x48 - Debounce enable register
    vu32 porta_eoi;                 // 0x4c - Port A clear interrupt register
    vu32 ext_porta;                 // 0x50 - Port A external port register
    vu32 ext_portb;                 // 0x54 - Port B external port register
    vu32 ext_portc;                 // 0x58 - Port C external port register
    vu32 ext_portd;                 // 0x5c - Port D external port register
    vu32 ls_sync;                   // 0x60 - Level-sensitive synchronization enable register
    vu32 id_code;                   // 0x64 - ID code register
    vu32 int_bothedge;              // 0x68 - Interrupt both edge type
    vu32 ver_id_code;               // 0x6c - Component Version register
    APB_GPIO_CONFIG_REG2_Typedef config_reg2; // 0x70 - Configuration Register 2
    APB_GPIO_CONFIG_REG1_Typedef config_reg1; // 0x74 - Configuration Register 1
} APB_GPIO_Typedef;


//------------------------------------------------------------------
// API prototypes
//------------------------------------------------------------------

/**
  * @brief  Fills each GPIO_InitStruct member with its default value.
  * @param  GPIO_InitStruct : pointer to a GPIO_InitTypeDef structure which will
  *         be initialized.
  * @retval None
  */
void        GPIO_DeInitStructure(GPIO_InitTypeDef* GPIO_InitStruct);

/**
  * @brief  Deinitializes the GPIOx peripheral registers to their
  *         default reset values.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @retval None
  */
void        GPIO_DeInit(GPIO_Typedef* GPIOx);

/**
  * @brief  Initializes the GPIOx peripheral according to the specified
  *         parameters in the GPIO_InitStruct.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @param  GPIO_InitStruct: pointer to a GPIO_InitTypeDef structure that contains
  *         the configuration information for the specified GPIO peripheral.
  * @retval None
  */
void        GPIO_Init(GPIO_Typedef* GPIOx, GPIO_InitTypeDef* GPIO_InitStruct);

/**
  * @brief  Reads the specified input port pin.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @param  GPIO_Pin:  specifies the port bit to read.
  *         This parameter can be GPIO_Pin_x where x can be (0..3).
  * @retval The input port pin value.
  */
FlagStatus  GPIO_ReadInputDataBit(GPIO_Typedef* GPIOx, uint32_t GPIO_Pin);

/**
  * @brief  Reads the specified GPIO input data port.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @retval GPIO input data port value.
  */
uint32_t    GPIO_ReadInputData(GPIO_Typedef* GPIOx);

/**
  * @brief  Reads the specified output data port bit.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @param  GPIO_Pin:  specifies the port bit to read.
  *         This parameter can be GPIO_Pin_x where x can be (0..3).
  * @retval The output port pin value.
  */
FlagStatus  GPIO_ReadOutputDataBit(GPIO_Typedef* GPIOx, uint32_t GPIO_Pin);

/**
  * @brief  Reads the specified GPIO output data port.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @retval GPIO output data port value.
  */
uint32_t    GPIO_ReadOutputData(GPIO_Typedef* GPIOx);

/**
  * @brief  Sets the selected data port bits.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @param  GPIO_Pin:  specifies the port bit to read.
  *         This parameter can be GPIO_Pin_x where x can be (0..3).
  * @retval None
  */
void        GPIO_SetBits(GPIO_Typedef* GPIOx, uint32_t GPIO_Pin);

/**
  * @brief  Clears the selected data port bits.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @param  GPIO_Pin:  specifies the port bit to read.
  *         This parameter can be GPIO_Pin_x where x can be (0..3).
  * @retval None
  */
void        GPIO_ResetBits(GPIO_Typedef* GPIOx, uint32_t GPIO_Pin);

/**
  * @brief  Sets or clears the selected data port bit.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @param  GPIO_Pin:  specifies the port bit to read.
  *         This parameter can be GPIO_Pin_x where x can be (0..3).
  * @param  BitVal: specifies the value to be written to the selected bit.
  *         This parameter can be one of the BitAction enum values:
  *         @arg RESET: to clear the port pin
  *         @arg SET: to set the port pin
  * @retval None
  */
void        GPIO_WriteBit(GPIO_Typedef* GPIOx, uint32_t GPIO_Pin, FlagStatus BitVal);

/**
  * @brief  Writes data to the specified GPIO data port.
  * @param  GPIOx: where x can be (A..C) to select the GPIO peripheral.
  * @param  PortVal: specifies the value to be written to the port output data register.
  *         Only low 4bits is effective.
  * @retval None
  */
void        GPIO_Write(GPIO_Typedef* GPIOx, uint32_t PortVal);

/**
  * @brief  Changes the mapping of the specified pin.
  * @param  PinNum: The pin needed to be remapped
  *         This parameter can be one of the ChipPinNumTypeDef enum values.
  * @param  Pin_Remap: The pin new function.
  *         This parameter should be selected from pin function list.
  *         @arg ChipP01: P01FUNC_SPI0_MOSI_O
  *                       P01FUNC_UART1_CTS_I
  *         @arg ChipP02: P02FUNC_SPI0_SSN_O
  *                       P02FUNC_UART1_RTS_O
  *         @arg ChipP03: P03FUNC_SPI0_SCK_O
  *                       P03FUNC_UART1_TX_O
  *         @arg ChipP04: P04FUNC_SPI0_MISO_I
  *                       P04FUNC_UART1_RX_I
  *                       P04FUNC_GPIO3_8_O
  *         @arg ChipP09: P09FUNC_JTDI_I
  *                       P09FUNC_UART2_RX_I
  *                       P09FUNC_GPIO3_10_O
  *                       P09FUNC_GPIO3_10_I
  *         @arg ChipP10: P10FUNC_JTDO_O
  *                       P10FUNC_UART2_TX_O
  *                       P10FUNC_GPIO3_11_O
  *                       P10FUNC_GPIO3_11_I
  *         @arg ChipP11: P11FUNC_TRSTN_I
  *                       P11FUNC_UART2_CTS_I
  *                       P11FUNC_GPIO3_9_O
  *                       P11FUNC_GPIO3_9_I
  *         @arg ChipP12: P12FUNC_GPIO3_0_O
  *                       P12FUNC_UART2_RTS_O
  *                       P12FUNC_GPIO3_0_I
  *         @arg ChipP13: P13FUNC_GPIO3_1_O
  *                       P13FUNC_I2S0_WS_O
  *                       P13FUNC_SPI1_SSN_O
  *                       P13FUNC_GPIO3_1_I2S1_WS_SYNO_CODEC_I
  *         @arg ChipP14: P14FUNC_GPIO3_2_O
  *                       P14FUNC_I2S0_CLK_SEL_STAGE1_O
  *                       P14FUNC_SPI1_SCK_O
  *                       P14FUNC_GPIO3_2_I2S0_CLK_I2S1_CLK_SYNO_CODEC_I
  *         @arg ChipP15: P15FUNC_GPIO3_3_O
  *                       P15FUNC_GPIO3_3_I
  *                       P15FUNC_SPI1_MISO_I2S0_RX_I
  *                       P15FUNC_I2S1_RX_SYNO_CODEC_O
  *         @arg ChipP16: P16FUNC_GPIO3_4_O
  *                       P16FUNC_I2S0_TX_O
  *                       P16FUNC_SPI1_MOSI_O
  *                       P16FUNC_GPIO3_4_I2S1_TX_SYNO_CODEC_I
  *         @arg ChipP17: P17FUNC_GPIO3_5_O
  *                       P17FUNC_GPIO3_5_I
  *                       P17FUNC_MSCLK1_SYNO_CODEC_I
  *         @arg ChipP24: P24FUNC_GPIO3_6_O
  *                       P24FUNC_TCK_SWCLK_I
  *                       P24FUNC_GPIO3_6_I
  *         @arg ChipP25: P25FUNC_SWDIO_TMS_O
  *                       P25FUNC_GPIO3_7_O
  *                       P25FUNC_GPIO3_7_I
  *                       P25FUNC_SWDIO_TMS_I
  *         @arg ChipP26: P26FUNC_I2C0_SDA_O
  *                       P26FUNC_I2C0_SDA_I
  *         @arg ChipP27: P27FUNC_I2C0_SCL_O
  *                       P27FUNC_I2C0_SCL_I
  * @param  NewState: new state of the port pin remapping.
  *         This parameter can be: ENABLE or DISABLE.
  * @return None
  */
void GPIO_PinRemapConfig(ChipPinNumTypeDef PinNum, uint8_t Pin_Remap, FunctionalState NewState);


//void GPIO_SetMode(GPIO_Typedef* GPIOx, GPIO_Pin pin, GPIO_Mode mode);

#endif // __ACH118X_GPIO_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/

