/***************************************************************************************************
 *                              MCU ACH118X driver library
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     ach1180x_conf.h
 * @brief    Configuration for the ACH firmware library.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __ACH1180x_CONF_H
#define __ACH1180x_CONF_H

//Include files
#include "ACH118x_type.h"

#define MASK_BIT(mask, shift) ((uint32_t)(mask) << (shift))
#define MASK_1_BIT(org) ((uint32_t)0x1 << (org))
#define MASK_2_BIT(org) ((uint32_t)0x3 << (org))
#define MASK_3_BIT(org) ((uint32_t)0x7 << (org))
#define MASK_4_BIT(org) ((uint32_t)0xf << (org))
#define MASK_5_BIT(org) ((uint32_t)0x1f << (org))
#define MASK_6_BIT(org) ((uint32_t)0x3f << (org))
#define MASK_7_BIT(org) ((uint32_t)0x7f << (org))
#define MASK_8_BIT(org) ((uint32_t)0xff << (org))
#define MASK_9_BIT(org) ((uint32_t)0x1ff << (org))
#define MASK_10_BIT(org) ((uint32_t)0x3ff << (org))
#define MASK_11_BIT(org) ((uint32_t)0x7ff << (org))
#define MASK_12_BIT(org) ((uint32_t)0xfff << (org))
#define MASK_13_BIT(org) ((uint32_t)0x1fff << (org))
#define MASK_14_BIT(org) ((uint32_t)0x3fff << (org))
#define MASK_15_BIT(org) ((uint32_t)0x7fff << (org))
#define MASK_16_BIT(org) ((uint32_t)0xffff << (org))
#define MASK_17_BIT(org) ((uint32_t)0x1ffff << (org))
#define MASK_18_BIT(org) ((uint32_t)0x3ffff << (org))
#define MASK_19_BIT(org) ((uint32_t)0x7ffff << (org))
#define MASK_20_BIT(org) ((uint32_t)0xfffff << (org))
#define MASK_21_BIT(org) ((uint32_t)0x1fffff << (org))
#define MASK_22_BIT(org) ((uint32_t)0x3fffff << (org))
#define MASK_23_BIT(org) ((uint32_t)0x7fffff << (org))
#define MASK_24_BIT(org) ((uint32_t)0xffffff << (org))
#define MASK_25_BIT(org) ((uint32_t)0x1ffffff << (org))
#define MASK_26_BIT(org) ((uint32_t)0x3ffffff << (org))
#define MASK_27_BIT(org) ((uint32_t)0x7ffffff << (org))
#define MASK_28_BIT(org) ((uint32_t)0xfffffff << (org))
#define MASK_29_BIT(org) ((uint32_t)0x1fffffff << (org))
#define MASK_30_BIT(org) ((uint32_t)0x3fffffff << (org))
#define MASK_31_BIT(org) ((uint32_t)0x7fffffff << (org))

//#define DEBUG    1

/* Comment the line below to disable the specific peripheral inclusion */
/************************************* ADC ************************************/
#define _SYSCFG
#define _ADC
#define _ADC0
#define _ADC1
#define _DMA
#define _EXTI
#define _GPIO
#define _GPIOA
#define _GPIOB
#define _GPIOC
#define _EXTI
#define _WDT
#define _I2C
#define _I2C1
#define _I2C2
#define _I2S
#define _I2S0
#define _I2S1
#define _SPI
#define _SPI0
#define _SPI1
#define _SPI2
#define _TIM
#define _UART0
#define _UART1
#define _UART2

#ifdef  DEBUG
#define assert_param(expr) ((expr) ? (void)0 : assert_failed((uint8_t *)__FILE__, __LINE__))
void assert_failed(uint8_t* file, uint32_t line);
#else
#define assert_param(expr) ((void)0)
#endif /* DEBUG */

#endif /* __ACH1180x_CONF_H */

/************************ (C) COPYRIGHT ART *****END OF FILE****/

