/***************************************************************************************************
 *                              MCU ACH118X driver library
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     ach118x.h
 * @brief    Included headers for ach118x driver.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __ACH118X_H
#define __ACH118X_H

#include <stdint.h>
#include <string.h>
#include "ach118x_type.h"
#include "ach118x_map.h"
#include "ach118x_device.h"
#include "ach118x_misc.h"
#include "core_cm4.h"             /* Cortex-M4 processor and core peripherals */
#include "system_ach118x.h"
#include "ach118x_it.h"


//------------------------------------------------------------------------------
// Uncomment the line below to enable peripheral header file inclusion
//------------------------------------------------------------------------------
#include "ach118x_sys.h"
#include "ach118x_i2s.h"
#include "ach118x_spi.h"
#include "ach118x_timer.h"
#include "ach118x_uart.h"
#include "ach118x_codec.h"
#include "ach118x_util.h"
#include "ach118x_i2c.h"
#include "ach118x_gpio.h"
#include "ach118x_dma.h"
//#include "ach118x_file.h"

#endif // __ACH118X_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/

