/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_wtd.c
 * @brief    GKI function interface for Watchdog (WDT).
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include "ach118x_wdt.h"
#include "ach118x_sys.h"
#include "GKI_wtd.h"

//*******************************************************************************
// Description: Watchdog initialise.
// Arguments  : None.
// Returns    : None.
//*******************************************************************************
void GKI_WtdInit(void)
{
    SYS_WdtClockCmd(ENABLE);
    SYS_WdtHardwareResetCmd(ENABLE);
    //SYSCFG_SetPeripheralResetForWdt(SYSCFG, RESET_System, ENABLE);
    SYS_SetITMaskFlag(IRQ_WatchDog, SET);
    NVIC_EnableIRQ(WDT_IRQn);
    WDT_Unlock();
    WDT_SetTIM(WTD_INIT_VALUE);
    WDT_ITCmd(ENABLE);
    WDT_Cmd(ENABLE);
}

//*******************************************************************************
// Description: WatchDog control interface.
// Arguments  : NewState    This param can be one of @FunctionalState enum:
//                          @arg ENABLE: Enable Watch Dog.
//                          @arg DISABLE: Disable Watch Dog.
// Returns    : None.
//*******************************************************************************
void GKI_WtdCmd(FunctionalState NewState)
{
    WDT_ITCmd(NewState);
    WDT_Cmd(NewState);
}

//*******************************************************************************
// Description: WatchDog control interface.
// Arguments  : CounterValue    Feed WatchDog with new conter value.
// Returns    : None.
//*******************************************************************************
void GKI_FeedWatchdog(uint32_t CounterValue)
{
    WDT_SetTIM(CounterValue);
}

/************************ (C) COPYRIGHT ART *****END OF FILE****/

