/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_sys.c
 * @brief    GKI function interface for system.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include "ach118x.h"

#define SYSTEM_CLOCK_xxx_Mhz (200)//(UART_CLOCK/1000000*2)

//---------------------------------------------------
// Set system clock, unit is Mhz
//---------------------------------------------------
void GKI_SetSystemClock(uint16_t Mhz)
{
    SYS_SetPLL0_xxxMhz(Mhz);
    SystemCoreClock = (uint32_t)1000000 * Mhz;
}

//---------------------------------------------------
// Get system clock
//---------------------------------------------------
uint32_t GKI_GetSystemClock(void)
{
    return SystemCoreClock;
}

//---------------------------------------------------
// Used to initialise the system clock setting
//---------------------------------------------------
void GKI_SystemInit(void)
{
    SYS_SystemClockSourceSelect(CLOCK_SRC_Osc);
    GKI_SetSystemClock(SYSTEM_CLOCK_xxx_Mhz);
    while(SYS_GetPLL0LockStatus() != SET);
    SYS_SystemClockSourceSelect(CLOCK_SRC_Pll0);
}

//---------------------------------------------------
// Used to initialise the system clock setting
//---------------------------------------------------
void GKI_SetCpuMhz(uint8_t Mhz)
{
    SYS_SystemClockSourceSelect(CLOCK_SRC_Osc);
    GKI_SetSystemClock(Mhz);
    while(SYS_GetPLL0LockStatus() != SET);
    SYS_SystemClockSourceSelect(CLOCK_SRC_Pll0);
}

//---------------------------------------------------
// Used to reset the system
//---------------------------------------------------
void GKI_SystemReset(void)
{

    //NVIC_SystemReset();
    //SYS_SetPeripheralResetForWdt
    SYS_ResetInterface(RESET_All);
}

/************************ (C) COPYRIGHT ART *****END OF FILE****/

