/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_irq.c
 * @brief    GKI callbacks for interrupts.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include <stdio.h>
#include <stdint.h>
#include "ach118x_it.h"
#include "ach118x_map.h"
#include "ach118x_uart.h"
#include "ach118x_exti.h"
#include "ach118x_spi.h"
#include "GKI_Spi.h"
#include "GKI_codec.h"
#include "GKI_adc.h"

#ifdef ENB_BYPASS
#include "TM_UARTDriver.h"
#include "PoolPlug.h"
#endif

//extern int getd(void);
void GKI_CallBackSpi0Irq(void)
{
    /*write your interrupt server code*/
    extern SpiCtrlInfo_t xCW1200SpiCtrlInfo;
    if(RESET != SPI_GetITFlag(SPI0, IT_TXE_Flag)) {
        if(NULL != xCW1200SpiCtrlInfo.txeCallBack) {
            xCW1200SpiCtrlInfo.txeCallBack(&xCW1200SpiCtrlInfo);
//            if(getd() == 1)
//                printu("%s %d txeCallBack\r\n", __func__, __LINE__);
        }
    }
    if(RESET != SPI_GetITFlag(SPI0, IT_RXF_Flag)) {
        if(NULL != xCW1200SpiCtrlInfo.rxfCallBack) {
            xCW1200SpiCtrlInfo.rxfCallBack(&xCW1200SpiCtrlInfo);
//            if(getd() == 1)
//                printu("%s %d rxfCallBack\r\n", __func__, __LINE__);
        }
    }    
}

void GKI_CallBackSpi1Irq(void)
{
     /*write your interrupt server code*/
    extern SpiCtrlInfo_t xExtIntSpiCtrlInfo;

    if(RESET != SPI_GetITFlag(SPI1, IT_TXE_Flag)) {

        if(NULL != xExtIntSpiCtrlInfo.txeCallBack) {
            xExtIntSpiCtrlInfo.txeCallBack(&xExtIntSpiCtrlInfo);
        }
    }
    else if(RESET != SPI_GetITFlag(SPI1, IT_RXF_Flag)) {
        if(NULL != xExtIntSpiCtrlInfo.rxfCallBack) {
            xExtIntSpiCtrlInfo.rxfCallBack(&xExtIntSpiCtrlInfo);
        }
    }
}

void GKI_CallBackSpi2Irq(void)
{
    /*write your interrupt server code*/
    extern SpiCtrlInfo_t xFlashSpiCtrlInfo;

    if(RESET != SPI_GetITFlag(SPI2, IT_TXE_Flag)) {
        if(NULL != xFlashSpiCtrlInfo.txeCallBack) {
            xFlashSpiCtrlInfo.txeCallBack(&xFlashSpiCtrlInfo);
        }
    }
    if(RESET != SPI_GetITFlag(SPI2, IT_RXF_Flag)) {
        if(NULL != xFlashSpiCtrlInfo.rxfCallBack) {
            xFlashSpiCtrlInfo.rxfCallBack(&xFlashSpiCtrlInfo);
        }
    }
}

void GKI_CallBackI2s0Irq(void)
{
    /*write your interrupt server code*/
}
uint32_t timeout_cnt = 0;
extern uint8_t ipsnd_force_tx;
#ifdef ENB_BYPASS
extern tTM_UartDev         TM_UartDev[1];
extern SemaphoreHandle_t xUartRxSem;
#endif
void GKI_CallBackUart0Irq(void)
{
    /*write your interrupt server code*/
    //TX FIFO empty interrupt.
    if(RESET != UART_GetITFlag(UART0, UART_THR_EMPTY)) {
        UART_ITCmd(UART0, UART_TX_EMPTY_IT, DISABLE);
    }
    //RX FIFO full or timeout interrupt.
    if((RESET != UART_GetITFlag(UART0, UART_RXD_AVAILABLE)) || \
       (RESET != UART_GetITFlag(UART0, UART_CHAR_TIMEOUT))) {

        if(RESET != UART_GetITFlag(UART0, UART_CHAR_TIMEOUT)) {
            timeout_cnt++;
            //trigger IP send
            ipsnd_force_tx = 1;
#if 0
            extern SemaphoreHandle_t xUartRecvDataTmrOut;
            BaseType_t xHigherPriTaskWoken;
            xSemaphoreGiveFromISR(xUartRecvDataTmrOut, &xHigherPriTaskWoken);
#endif
        }
#ifndef ENB_BYPASS
        extern SemaphoreHandle_t xUartRecvDataSmphr;
        BaseType_t xHigherPriorityTaskWoken = pdFALSE;
//        printf("%s %d jiffies = %d\r\n", __func__, __LINE__, xTaskGetTickCount());
        xSemaphoreGiveFromISR(xUartRecvDataSmphr, &xHigherPriorityTaskWoken);
        UART_ITCmd(UART0, UART_RCV_DATA_IT, DISABLE);
#else
        uint8_t* buf;

        UART_ITCmd(UART0, UART_RCV_DATA_IT, DISABLE);
//        printf("%s %d UART0->DI.IER = %08x, DISABLE\r\n", __func__, __LINE__, UART0->DI.IER);

        buf = (uint8_t*)BP_GetFromPoolFromIRQ(TM_UartDev[0].Rx.pPool);
//        printf("%s %d buf = %p\r\n", __func__, __LINE__, buf);
//        taskENTER_CRITICAL();
        if((void*)0 != buf) {
            tBP_MemBlockNode* blockNode;
            blockNode = BP_BindBlockNode(&memBlockTxMng, buf);
            while(GKI_UartRxDataReady(UART0)){
                //buf[blockNode->payload++] = UART_ReceiveData(UART0);
                buf[blockNode->payload++] = GKI_UartReceiveData(UART0);
            }
//            printf("%s %d payload = %d \r\n", __func__, __LINE__, blockNode->payload);
        }
        else{
            //drop data, avoid irq frequencyly
            while(GKI_UartRxDataReady(UART0)){
                GKI_UartReceiveData(UART0);
            }
            printf("%s %d no pool\r\n", __func__, __LINE__);
        }

        BaseType_t xHigherPriorityTaskWoken = pdFALSE;
        //Only first package give the semaphore.
        if(1 == BP_GetUsedBlockCnt(&memBlockTxMng)) {
//            xSemaphoreGive(xUartRxSem);
            xSemaphoreGiveFromISR(xUartRxSem, &xHigherPriorityTaskWoken);
//            printf("%s %d xUartRxSem give\r\n", __func__, __LINE__);
        }
        else{
//            printf("%s %d no give\r\n", __func__, __LINE__);
        }
//        taskEXIT_CRITICAL();
        GKI_UartITCmd(UART0, RCV_DATA_IT, ENABLE);
//        printf("%s %d  UART0->DI.IER = %08x ENABLE\r\n", __func__, __LINE__,  UART0->DI.IER);
#endif
    }
}

void GKI_CallBackUart1Irq(void)
{
    /*write your interrupt server code*/
      if(UART_GetITFlag(UART1, UART_RXD_AVAILABLE) == SET) {

    }
}

void GKI_CallBackUart2Irq(void)
{
    /*write your interrupt server code*/
      if(UART_GetITFlag(UART2, UART_RXD_AVAILABLE) == SET) {
    }
}
extern uint32_t AudioMode;
void GKI_CallBackI2s1Irq(void)
{
#if defined(ENABLE_WavePlayer) || defined(ENABLE_VoiceRecord)
    extern void I2S1_IRQHandler_cb(void);
    extern void I2S1_IRQHandler_sampler_cb(void);
    if(AudioMode == 0)
        I2S1_IRQHandler_cb();
    else if(AudioMode == 1)
        I2S1_IRQHandler_sampler_cb();
#endif
}

void GKI_CallBackI2cIrq(void)
{
    /*write your interrupt server code*/
}

void GKI_CallBackTimIrq(void)
{
    /*write your interrupt server code*/
#if defined(ENABLE_WavePlayer)
    extern void TIM0_IRQHandler_cb(void);
    TIM0_IRQHandler_cb();
#endif
}

void GKI_CallBackGpioIrq(void)
{
    /*write your interrupt server code*/
    if(EXTI_GetITFlag(PIN_GPIO_0)) {
        extern void CW1200_Exti_Isr( void );
        CW1200_Exti_Isr();
        EXTI_ClearITFlag(PIN_GPIO_0);
    }
    else if(EXTI_GetITFlag(PIN_GPIO_1)) {

        EXTI_ClearITFlag(PIN_GPIO_1);
    }
    else if(EXTI_GetITFlag(PIN_GPIO_2)) {

        EXTI_ClearITFlag(PIN_GPIO_2);
    }
    else if(EXTI_GetITFlag(PIN_GPIO_3)) {
        EXTI_ClearITFlag(PIN_GPIO_3);
    }
}
void GKI_CallBackWdtIrq(void)
{
    /*write your interrupt server code*/
}

void GKI_CallBackAdc0Irq(void)
{

}

void GKI_CallBackAdc1Irq(void)
{
    /*write your interrupt server code*/
}

void GKI_CallBackAesIrq(void)
{
    /*write your interrupt server code*/
}

void GKI_CallBackDmaIrq(void)
{
    /*write your interrupt server code*/
}



void GKI_RegisterAllIrq(void)
{
    RegisterIrqFunction(GKI_CallBackSpi0Irq,  SPI0IRQ);
    RegisterIrqFunction(GKI_CallBackSpi1Irq,  SPI1IRQ);
    RegisterIrqFunction(GKI_CallBackSpi2Irq,  SPI2IRQ);
    RegisterIrqFunction(GKI_CallBackI2s0Irq,  I2S0IRQ);
    RegisterIrqFunction(GKI_CallBackUart0Irq, UART0IRQ);
    RegisterIrqFunction(GKI_CallBackUart1Irq, UART1IRQ);
    RegisterIrqFunction(GKI_CallBackUart2Irq, UART2IRQ);
    RegisterIrqFunction(GKI_CallBackI2s1Irq,  I2S1IRQ);
    RegisterIrqFunction(GKI_CallBackI2cIrq,   I2CIRQ);
    RegisterIrqFunction(GKI_CallBackTimIrq,   TIM0IRQ);
    RegisterIrqFunction(GKI_CallBackGpioIrq,  GPIOIRQ);
    RegisterIrqFunction(GKI_CallBackWdtIrq,   WDTIRQ);
    RegisterIrqFunction(GKI_CallBackAdc0Irq,  ADC0IRQ);
    RegisterIrqFunction(GKI_CallBackAdc1Irq,  ADC1IRQ);
    RegisterIrqFunction(GKI_CallBackDmaIrq,   AESIRQ);
    RegisterIrqFunction(GKI_CallBackDmaIrq,   DMAIRQ);
}

