/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_gpio.c
 * @brief    GKI function interface for GPIO.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include "GKI_gpio.h"
#include "GKI_uart.h"
#include "ach118x_sys.h"
#include "ach118x_map.h"
#include <stdio.h>
#include <stdint.h>

typedef struct{
    GPIO_Typedef *GPIOx;
    GPIO_Pin     Pin;
}GPIO_PORT;
static const GPIO_PORT sGpioPortTbl[]={
  {GPIOA, Pin_0}, //GPIO 0
  {GPIOA, Pin_1}, //GPIO 1
  {GPIOA, Pin_2}, //GPIO 2
  {GPIOA, Pin_3}, //GPIO 3
  {GPIOB, Pin_0}, //GPIO 4
  {GPIOB, Pin_1}, //GPIO 5
  {GPIOB, Pin_2}, //GPIO 6
  {GPIOB, Pin_3}, //GPIO 7
  {GPIOC, Pin_0}, //GPIO 8
  {GPIOC, Pin_1}, //GPIO 9
  {GPIOC, Pin_2}, //GPIO 10
  {GPIOC, Pin_3}  //GPIO 11
};
void GKI_GPIO_PortSetMode(uint8_t PortNo, uint8_t mode)
{
    GPIO_InitTypeDef GPIO_InitStruct;
    SYS_PinRemap(PortNo,mode);
    GPIO_Typedef* GPIOx = sGpioPortTbl[PortNo].GPIOx;
    GPIO_Pin pin = sGpioPortTbl[PortNo].Pin;
    //GPIO_SetMode(GPIOx, pin, mode);
    GPIO_InitStruct.GPIO_Pin = pin;
    if(mode){
        GPIO_InitStruct.Pin_Mode = GPIO_PIN_OUTPUT;
    }else{
        GPIO_InitStruct.Pin_Mode = GPIO_PIN_INPUT;
    }
    GPIO_InitStruct.Pin_Status = SET;

    GPIO_Init(GPIOx, &GPIO_InitStruct);
}

void GKI_GPIO_PortSet(uint8_t PortNo)
{
    GPIO_Typedef* GPIOx = sGpioPortTbl[PortNo].GPIOx;
    GPIO_Pin pin = sGpioPortTbl[PortNo].Pin;
    GPIO_SetBits(GPIOx, pin);
}

void GKI_GPIO_PortReset(uint8_t PortNo)
{
    GPIO_Typedef* GPIOx = sGpioPortTbl[PortNo].GPIOx;
    GPIO_Pin pin = sGpioPortTbl[PortNo].Pin;
    GPIO_ResetBits(GPIOx, pin);
}
FlagStatus GKI_GPIO_PortRead(uint8_t PortNo)
{
    GPIO_Typedef* GPIOx = sGpioPortTbl[PortNo].GPIOx;
    GPIO_Pin pin = sGpioPortTbl[PortNo].Pin;
    return GPIO_ReadInputDataBit(GPIOx, pin);
}


/************************ (C) COPYRIGHT ART *****END OF FILE****/

