/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_flash.c
 * @brief    GKI functions used for FLASH.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

/*************************************
* These API is used to flash driver
**************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "GKI_spi.h"
#include "GKI_flash.h"
#include "stdio.h"
#include "ach118x_uart.h"
#include "ach118x_map.h"
#include "flash.h"


#define SPI_THRESHOLD   11  // FIFO threshold
#define SPI_DEV         SPI2
#define SPI_IRQn        SPI2_IRQn
#define SPI_IRQ         IRQ_SPI2
#define SPI_PRIORITY    8


/*************************************
* Init flash structure
**************************************/
void GKI_FlashInit(void)
{
    GKI_FLASH_SpiInit(SPI_DEV);

    SYS_SetITMaskFlag(SPI_IRQ, SET);
    NVIC_EnableIRQ(SPI_IRQn);
    NVIC_SetPriority(SPI_IRQn, SPI_PRIORITY);

    GKI_SpiCtrlInfoInit(&xFlashSpiCtrlInfo, SPI2);
    GKI_SpiRegTxeHandler(&xFlashSpiCtrlInfo, GKI_SpiFlashTx_CallBack);
    GKI_SpiRegRxfHandler(&xFlashSpiCtrlInfo, GKI_SpiFlashRx_CallBack);
}

/********************************************************************/
void GKI_FlashReadID(uint8_t *pBuf)
{
    // MD25D80_ReadManufactureID(SPI2,pBuf);
    FLASH_ReadManufactureID(pBuf);
}
/********************************************************************/
void GKI_FlashSectorErase(uint32_t addr)
{
    //MD25D80_SectorErase(SPI2, addr);
    FLASH_SectorErase(addr);
}
/********************************************************************/
void GKI_FlashErase(uint32_t addr, uint32_t len)
{
    // MD25D80_EraseBySector(SPI2, addr, len);
    FLASH_EraseBySector(addr, len);
}

/********************************************************************/
void GKI_FlashWrite(uint32_t addr, uint8_t *pBuf, uint32_t len)
{
    //MD25D80_WriteData(SPI2, addr, pBuf, len);
    FLASH_Write(addr, pBuf, len);
}

/********************************************************************/
void GKI_FlashRead(uint32_t addr, uint8_t *pBuf, uint32_t len)
{
    //MD25D80_ReadData(SPI2, addr, pBuf, len);
    FLASH_Read(addr, pBuf, len);
}

