/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_exti.c
 * @brief    GKI functions for EXTI.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include "ach118x_exti.h"
#include "ach118x_sys.h"
#include "ach118x_it.h"

//************************************************************************************
// Description: get exti pin status for whether it is triggerred or not
// Arguments  : pin, the interrupt input pin
// Returns    : FlagStatus
//                    SET, interrupt has been triggered
//                    RESET, interrupt hasn't been triggered
//************************************************************************************
FlagStatus GKI_ExtiGetITFlag(ExtiPin pin)
{
    return EXTI_GetITFlag(pin);
}

//************************************************************************************
// Description: clear exti interrput status
// Arguments  : pin, the interrupt input pin
// Returns    : NONE
//************************************************************************************
void GKI_ExtiClearITFlag(ExtiPin pin)
{
    EXTI_ClearITFlag(pin);
}
/*****************These functions is  for ACC1340*************/
void GKI_ACC1340_ExtiInit(ExtiPin pin)
{

    EXTI_InitTypeDef EXTI_InitStruct;

    //EXTI_DeInit();
    EXTI_InitStruct.Cmd = ENABLE;
    EXTI_InitStruct.Pin = pin;
    EXTI_InitStruct.Type = TYPE_Edge;
    EXTI_InitStruct.Polarity = POLARITY_High;
    EXTI_InitStruct.EnDebounce = EN_Debounce;
    EXTI_InitStruct.En2Edge = DIS_2edge;
    EXTI_Init(&EXTI_InitStruct);

    EXTI_ClearITFlag(EXTI_InitStruct.Pin);

    NVIC_EnableIRQ(GPIO_IRQn);
    NVIC_SetPriority(GPIO_IRQn,6);
    SYS_SetITMaskFlag(IRQ_GPIO, SET);
}

/************************ (C) COPYRIGHT ART *****END OF FILE****/

