/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_dma.c
 * @brief    GKI functions for DMA.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include "ach118x_dma.h"
#include "GKI_sys.h"

volatile uint8_t gDmaTestItem;
volatile uint8_t gDmaTestState;
extern volatile uint8_t TestDst[256];
extern uint8_t TestBlk1[256], TestBlk2[256], TestBlk3[256], TestBlk4[256];

//*********************************************************************************************************
// Description: GKI_MultiBlkTransferTestInit
// Arguments  : TIMx: select TIM entity
//
// Returns    : none
//*********************************************************************************************************
void GKI_DMAChannelCmd(DMA_Channel Channel_Num, FunctionalState NewState)
{
      if(ENABLE == NewState) {
          DMA_Cmd(ENABLE);
        DMA_ChannelCmd(Channel_Num, NewState);
    }
}
//*********************************************************************************************************
// Description: GKI_SingleBlkTransferTestInit
// Arguments  : DMA_Channel_Typedef *Channel
//
// Returns    : none
//*********************************************************************************************************
void GKI_SingleBlkTransferTestInit(DMA_Channel_Typedef *Channel)
{
    DMA_ChannelInit_Typedef DMA_ChannelInitStructure;

    DMA_ChannelStructDeinit(&DMA_ChannelInitStructure);
    DMA_ChannelInitStructure.LLPLoc = 0;
    DMA_ChannelInitStructure.SrcAddress = (uint32_t)&TestBlk1;
    DMA_ChannelInitStructure.DstAddress = (uint32_t)&TestDst;
    DMA_ChannelInitStructure.IntEnable = FUNC_Enable;//FUNC_Disable;//FUNC_Enable;//
    DMA_ChannelInitStructure.SrcTrWidth = TR_64Bits;//TR_16Bits;//TR_8Bits;//TR_32Bits;
    DMA_ChannelInitStructure.DstTrWidth = TR_64Bits;//TR_16Bits;//TR_8Bits;//TR_32Bits;    //default 32Bits
    DMA_ChannelInitStructure.SrcAddrIncOpt = Increment;
    DMA_ChannelInitStructure.DstAddrIncOpt = Increment;
    DMA_ChannelInitStructure.SrcTrSize = MSIZE_8;//MSIZE_4;//MSIZE_1;//MSIZE_4;//MSIZE_8;
    DMA_ChannelInitStructure.DstTrSize = MSIZE_8;//MSIZE_4;//MSIZE_1;//MSIZE_4;//MSIZE_8;
    DMA_ChannelInitStructure.SrcGatherEn = FUNC_Enable;
    DMA_ChannelInitStructure.DstScatterEn = FUNC_Enable;
    DMA_ChannelInitStructure.FlowCtrlType = M2M_DMA;
    DMA_ChannelInitStructure.SrcMasterOpt = Master_1;
    DMA_ChannelInitStructure.SrcMasterOpt = Master_1;
    DMA_ChannelInitStructure.DstLLPEn = FUNC_Disable;//T1
    DMA_ChannelInitStructure.SrcLLPEn = FUNC_Disable;//T1
    //DMA_ChannelInitStructure.BlockTsize = BLOCK_TS_256Bits;//BLOCK_TS_32Bits;//BLOCK_TS_16Bits;//BLOCK_TS_8Bits;//BLOCK_TS_64Bits;//BLOCK_TS_256Bits; //1024
    DMA_ChannelInitStructure.BlockTsize = 5;


    DMA_ChannelInitStructure.ChannelPrior = 7;
    //DMA_ChannelInitStructure.SrcHsSel = HS_HW;
    //DMA_ChannelInitStructure.DstHsSel = HS_SW;
    //DMA_ChannelInitStructure.SrcHsPol = ACHIVE_High;
    //DMA_ChannelInitStructure.DstHsPol = ACHIVE_High;
    //DMA_ChannelInitStructure.ChannelLockLevel = 0;
    //DMA_ChannelInitStructure.BusLockLevel = 0;
    DMA_ChannelInitStructure.ReloadSrcEn = FUNC_Disable;//T1
    DMA_ChannelInitStructure.ReloadDstEn = FUNC_Disable;//T1

    DMA_ChannelInitStructure.FcMode = FC_MODE_0;
    DMA_ChannelInitStructure.FifoMode = FIFO_MODE_0;

    DMA_ChannelInitStructure.SrcStatusEn = FUNC_Disable;
    DMA_ChannelInitStructure.DstStatusEn = FUNC_Disable;
    //DMA_ChannelInitStructure.SrcPER = 0;
    //DMA_ChannelInitStructure.DstPER = 1;

    DMA_ChannelInit(Channel, &DMA_ChannelInitStructure);
}



void GKI_SingleBlkTransferFlashTestInit(DMA_Channel_Typedef *Channel)
{
    DMA_ChannelInit_Typedef DMA_ChannelInitStructure;

    DMA_ChannelStructDeinit(&DMA_ChannelInitStructure);
    DMA_ChannelInitStructure.LLPLoc         = 0;
    DMA_ChannelInitStructure.SrcAddress     = (uint32_t)&TestBlk1;
    DMA_ChannelInitStructure.DstAddress     = (uint32_t)&TestDst;
    DMA_ChannelInitStructure.IntEnable      = FUNC_Enable;//FUNC_Disable;//FUNC_Enable;//
    DMA_ChannelInitStructure.SrcTrWidth     = TR_64Bits;//TR_16Bits;//TR_8Bits;//TR_32Bits;
    DMA_ChannelInitStructure.DstTrWidth     = TR_64Bits;//TR_16Bits;//TR_8Bits;//TR_32Bits;    //default 32Bits
    DMA_ChannelInitStructure.SrcAddrIncOpt  = Increment;
    DMA_ChannelInitStructure.DstAddrIncOpt  = Increment;
    DMA_ChannelInitStructure.SrcTrSize      = MSIZE_8;//MSIZE_4;//MSIZE_1;//MSIZE_4;//MSIZE_8;
    DMA_ChannelInitStructure.DstTrSize      = MSIZE_8;//MSIZE_4;//MSIZE_1;//MSIZE_4;//MSIZE_8;
    DMA_ChannelInitStructure.SrcGatherEn    = FUNC_Enable;
    DMA_ChannelInitStructure.DstScatterEn   = FUNC_Enable;
    DMA_ChannelInitStructure.FlowCtrlType   = M2M_DMA;
    DMA_ChannelInitStructure.SrcMasterOpt   = Master_1;
    DMA_ChannelInitStructure.SrcMasterOpt   = Master_1;
    DMA_ChannelInitStructure.DstLLPEn       = FUNC_Disable;//T1
    DMA_ChannelInitStructure.SrcLLPEn       = FUNC_Disable;//T1
    //DMA_ChannelInitStructure.BlockTsize = BLOCK_TS_256Bits;//BLOCK_TS_32Bits;//BLOCK_TS_16Bits;//BLOCK_TS_8Bits;//BLOCK_TS_64Bits;//BLOCK_TS_256Bits; //1024
    DMA_ChannelInitStructure.BlockTsize     = 16;


    DMA_ChannelInitStructure.ChannelPrior = 7;
    //DMA_ChannelInitStructure.SrcHsSel = HS_HW;
    //DMA_ChannelInitStructure.DstHsSel = HS_SW;
    //DMA_ChannelInitStructure.SrcHsPol = ACHIVE_High;
    //DMA_ChannelInitStructure.DstHsPol = ACHIVE_High;
    //DMA_ChannelInitStructure.ChannelLockLevel = 0;
    //DMA_ChannelInitStructure.BusLockLevel = 0;
    DMA_ChannelInitStructure.ReloadSrcEn = FUNC_Disable;//T1
    DMA_ChannelInitStructure.ReloadDstEn = FUNC_Disable;//T1

    DMA_ChannelInitStructure.FcMode = FC_MODE_0;
    DMA_ChannelInitStructure.FifoMode = FIFO_MODE_0;

    DMA_ChannelInitStructure.SrcStatusEn = FUNC_Disable;
    DMA_ChannelInitStructure.DstStatusEn = FUNC_Disable;
    //DMA_ChannelInitStructure.SrcPER = 0;
    //DMA_ChannelInitStructure.DstPER = 1;

    DMA_ChannelInit(Channel, &DMA_ChannelInitStructure);
}






//*********************************************************************************************************
// Description: get timer counter
// Arguments  : DMA_Channel_Typedef *Channel
//
// Returns    : none
//*********************************************************************************************************
void GKI_DMATestSingleBlockTransgerInit(DMA_Channel_Typedef *Channel)
{
     DMA_ChannelCmd(Channel_0, DISABLE);
    GKI_SingleBlkTransferTestInit(DMA_CHANNEL0);
    DMA_ClearChannelITStatus(Channel_0, IT_Blk);
    DMA_ClearChannelITStatus(Channel_0, IT_Dst);
    DMA_ClearChannelITStatus(Channel_0, IT_Err);
    DMA_ClearChannelITStatus(Channel_0, IT_Src);
    DMA_ClearChannelITStatus(Channel_0, IT_Tfr);
    DMA_ChannelITCmd(Channel_0, IT_Blk, ENABLE);
    //DMA_ChannelITCmd(Channel_0, IT_Dst, ENABLE);
    //DMA_ChannelITCmd(Channel_0, IT_Err, ENABLE);
    //DMA_ChannelITCmd(Channel_0, IT_Src, ENABLE);
    //DMA_ChannelITCmd(Channel_0, IT_Tfr, ENABLE);
    //DMA_Cmd(ENABLE);
    //DMA_ChannelCmd(Channel_0, ENABLE);
}


//*********************************************************************************************************
// Description: Enable/disable DMA
// Arguments  : FunctionalState NewState
//
// Returns    : none
//*********************************************************************************************************
void GKI_DMA_ITCmd(FunctionalState NewState)
{
    DMA_ITCmd(NewState);
}

/************************ (C) COPYRIGHT ART *****END OF FILE****/

