/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_codec.c
 * @brief    GKI functions for CODEC.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/

#include <stdio.h>
#include "ach118x.h"
#include "GKI_codec.h"

void GKI_CodecInit(uint32_t sampleRate)
{
    // Set I2S with Sample Rate
    if (util_ConfigAudioI2S_SampleRate(sampleRate) < 0) {
        printf("Invalid sample rate\r\n");
        return;
    }
    // Set Codec default
    codec_init();

    //==============================================================
    // Set Volume
    //==============================================================
    codec_set_master_volume(PLAYBACK_MASTER_VOLUME_MAX);
    codec_set_headset_volume(16);


    //set Codec
#if ASR_MICDIFF
    ASR_CODEC_WRRD_REG(71,MIC_DIFF);
    ASR_CODEC_WRRD_REG(72,MIC_DIFF);
#else
    ASR_CODEC_WRRD_REG(71,MIC_SINGLE);
    ASR_CODEC_WRRD_REG(72,MIC_SINGLE);
#endif

#if ASR_RECMAX
    ASR_CODEC_WRRD_REG(36,REC_MASTER_VOLUME_MAX);
    ASR_CODEC_WRRD_REG(37,REC_MASTER_VOLUME_MAX);
    ASR_CODEC_WRRD_REG(38,INP_PGA_VOLUME_MAX);
    ASR_CODEC_WRRD_REG(39,INP_PGA_VOLUME_MAX);
#endif

#if !ASR_USEDEFCFG
#if ASR_CODECREG200CMD
    ASR_CODEC_WRRD_REG(200,ASR_CODECREG200VAL);
#endif
#if ASR_CODECREG201CMD
    ASR_CODEC_WRRD_REG(201,ASR_CODECREG201VAL);
#endif
#if ASR_CODECREG202CMD
    ASR_CODEC_WRRD_REG(202,ASR_CODECREG202VAL);
#endif
#if ASR_CODECREG203CMD
    ASR_CODEC_WRRD_REG(203,ASR_CODECREG203VAL);
#endif
#if ASR_CODECREG204CMD
    ASR_CODEC_WRRD_REG(204,ASR_CODECREG204VAL);
#endif
#if ASR_CODECREG205CMD
    ASR_CODEC_WRRD_REG(205,ASR_CODECREG205VAL);
#endif
#endif

    if (codec_config_samplerate(sampleRate) < 0) {
        printf("Cannot set CODEC\r\n");
        return;
    }
    // do it again
    codec_config_samplerate(sampleRate);
#if 0
    //enable rx tx
    //taskENTER_CRITICAL();
    i2s1Txstart();
    i2s1Rxstart();
    //taskEXIT_CRITICAL();
#endif
    ASR_CODEC_WRRD_REG(36,11);
    ASR_CODEC_WRRD_REG(37,11);

    //Set voice volume
    codec_set_headset_volume(30);

}

void GKI_CodecGetLeft(int16_t *pBuf,unsigned short len)
{
    unsigned short i;
    for(i=0;i<len;i++){
        *(pBuf+i) = I2S1->Ch0.LFT.THR;
    }
}
void GKI_CodecPutLeft(int16_t *pBuf,unsigned short len)
{
    unsigned short i;
    for(i=0;i<len;i++){
        I2S1->Ch0.LFT.THR = *(pBuf+i);
    }
}


void GKI_CodecGetRight(int16_t *pBuf,unsigned short len)
{
    unsigned short i;
    for(i=0;i<len;i++){
        *(pBuf+i) = I2S1->Ch0.RGT.THR;
    }
}
void GKI_CodecPutRight(int16_t *pBuf,unsigned short len)
{
    unsigned short i;
    for(i=0;i<len;i++){
        I2S1->Ch0.RGT.THR = *(pBuf+i);
    }
}

char GKI_CodecRxDataReady(void)
{
    if(I2S1->Ch0.ISR & 0x1){
        return 1;
    }
    else{
        return 0;
    }
}
char GKI_CodecTxDataEmpty(void)
{
    if(I2S1->Ch0.ISR & 0x10)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}
void GKI_CodecTxStart(void)
{
    i2s1Txstart();
}
void GKI_CodecRxStart(void)
{
    i2s1Rxstart();
}

void GKI_CodecTxStop(void)
{
    i2s1TxStop();
}
void GKI_CodecRxStop(void)
{
    i2s1RxStop();
}

