/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_acc1340.c
 * @brief    Initializes the SPIx peripheral for master mode read/wirte half words
 * @version  V1.0.0
 * @date     05-Nov-2020.
 ***************************************************************************************************/

#include "ach118x.h"
#include "ach118x_spi.h"
#include "ach118x_sys.h"
#include "GKI_spi.h"

#define SPI_FIFO_DEPTH      22  //FIFO depth
#define SPI_THRESHOLD       11  //FIFO threshold

//*********************************************************************************************************
// Description: Initializes the SPIx peripheral for master mode read/wirte half words.
// Arguments  : SPIx    Where x can be (0, 1 or 2) to specified SPI peripheral.
// Returns    : None.
//*********************************************************************************************************

