/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_wtd.h
 * @brief    GKI structures and prototypes for Watchdog (WDT).
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_WTD_H
#define __GKI_WTD_H

#include "ach118x_type.h"
//Reset count value
#define WTD_INIT_VALUE  (50000000)//5 seconds

void GKI_WtdInit(void);
void GKI_WtdCmd(FunctionalState NewState);
void GKI_FeedWatchdog(uint32_t CounterValue);

#endif // __GKI_WTD_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

