/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_uart.h
 * @brief    GKI structures and prototypes for UART.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_UART_H
#define __GKI_UART_H

#include "ach118x_map.h"
#include "ach118x_uart.h"

/*
#define GKI_UART_LEN_5  (1)
#define GKI_UART_LEN_6  (2)
#define GKI_UART_LEN_7  (3)
*/
#define GKI_UART_LEN_8  (0)

#define GKI_UART_STOP_BIT_1     (0)
#define GKI_UART_STOP_BIT_2     (1)


#define GKI_NONE_PARITY         (0)
#define GKI_ODD_PARITY          (1)
#define GKI_EVEN_PARITY         (2)

void    GKI_UartInit(UART_Typedef* UARTx, uint32_t baudrate);
void    GKI_UartSendData(UART_Typedef* UARTx,uint8_t data);
uint8_t GKI_UartReceiveData(UART_Typedef* UARTx);
void    GKI_UartSendString(UART_Typedef* UARTx,char *str);
void    GKI_UartSendBytes(UART_Typedef* UARTx, uint8_t *p,uint16_t len);
void    GKI_Printf(char *fmt, ...);
uint8_t GKI_UartRxDataReady(UART_Typedef* UARTx);
uint8_t GKI_UartTxDataFinish(UART_Typedef* UARTx);
void    GKI_UartSetRTSLow(UART_Typedef* UARTx);
void    GKI_UartITCmd(UART_Typedef* UARTx, uint16_t UART_IT, FunctionalState NewState);
void    GKI_UartSetRTSHigh(UART_Typedef* UARTx);
uint8_t GKI_UartGetCTS(UART_Typedef* UARTx);

//IER (Interrupt Enable Register)
#define RCV_DATA_IT     (0x01)
#define TX_EMPTY_IT     (0x02)
#define RCV_LINE_IT     (0x04)
#define MODEM_IT        (0x08)
#define PROGRAMN_IT     (0x80)

#endif // __GKI_UART_H

