/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_tim.h
 * @brief    GKI functions and prototypes for timers.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_TIM_H
#define __GKI_TIM_H

#include "ach118x_map.h"
#include "ach118x_timer.h"

#define TIMER_SET_VALUE             (GKI_GetSystemClock() / 4)
#define TIMER_MAX_VALUE             (0xFFFFFFFF)
#define TIMER_STEP_FREQ_MHZ         (GKI_GetSystemClock() / 4000000)
#define TIMER_INTR_PERIOD_US        (TIMER_MAX_VALUE / TIMER_STEP_FREQ_MHZ)
#define TIMER_INTR_REMAIN_US        (TIMER_INTR_PERIOD_US % 1000)
/*
uint32_t GKI_TIMGetCounter(TIMER_TypeDef* TIMx);
void GKI_TIMSetCounter(TIMER_TypeDef *TIMx, uint32_t count);
uint8_t GKI_TIMGetITState(TIMER_TypeDef *TIMx);
void GKI_TIMClearITState(TIMER_TypeDef *TIMx);
void GKI_TIMCmd(TIMER_TypeDef *TIMx, FunctionalState NewState);
void GKI_TIMInit(TIMER_TypeDef *TIMx);
void GKI_TIMInit_FreeMode(TIMER_TypeDef *TIMx);
*/

#endif // __GKI_TIM_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

