/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_spi.h
 * @brief    GKI structures and prototypes for SPI.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_SPI_H
#define __GKI_SPI_H

#include "ach118x_spi.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"

//SPI0 FIFO opertions.
#define SPI0_FIFO_TX_DEPTH  (14)    //The TX FIFO depth.
#define SPI0_FIFO_RX_DEPTH  (22)    //The RX FIFO depth.
#define SPI0_FIFO_TXE_THD   (6)     //TXE IDLE space.
#define SPI0_FIFO_RXF_THD   (6)     //RXF fill space.

//SPI read/write buffer structure for interrupt.
typedef struct _SpiCtrlInfo_t {
    SPI_Typedef *SPIx;
    uint32_t    payload;
    //void *buf;
    //void *rdPtr;
    void *      wrPtr;
    void *      rcvPtr;
    void *      sndPtr;
    uint32_t    sndLen;
    uint32_t    sndSkp;
    uint32_t    rcvLen;
    uint32_t    rcvSkp;
    SemaphoreHandle_t rdDoneSem;
    SemaphoreHandle_t wrDoneSem;
    SemaphoreHandle_t mutex;
    void (*txeCallBack)(void *);
    void (*rxfCallBack)(void *);
} SpiCtrlInfo_t;

void    GKI_FLASH_SpiInit(SPI_Typedef* SPIx);
void    GKI_ACC1340_SpiInit(SPI_Typedef* SPIx);
void    GKI_SpiRdWrHalfWordBufWithIntr(SpiCtrlInfo_t *info, uint16_t *ptr, uint32_t payload);
void    GKI_ACC1340_SpiInit(SPI_Typedef* SPIx);
void    GKI_SpiSendHalfWord(SPI_Typedef* SPIx, uint16_t Data);
uint16_t GKI_SpiGetHalfWord(SPI_Typedef* SPIx);
FlagStatus GKI_SpiGetStatus(SPI_Typedef* SPIx, ST_Flag Flag);
void    GKI_SpiCtrlInfoInit(SpiCtrlInfo_t *info, SPI_Typedef *SPIx);
void    GKI_SpiRegTxeHandler(SpiCtrlInfo_t *info, void (*func)(void *));
void    GKI_SpiRegRxfHandler(SpiCtrlInfo_t *info, void (*func)(void *));
void    GKI_SpiFlashTx_CallBack(void *vInfo);
void    GKI_SpiFlashRx_CallBack(void *vInfo);
void    GKI_ACC1340_SpiTx_CallBack(void *vInfo);
void    GKI_ACC1340_SpiRx_CallBack(void *vInfo);
void    GKI_SpiSendAndGetDatas(SPI_Typedef* SPIx, uint8_t *pSndBuf, uint32_t SndLen, uint8_t *pRcvBuf, uint32_t RcvLen, uint16_t ShiftIdx);

#endif // __GKI_SPI_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

