/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_Queue.h
 * @brief    GKI queue library.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_QUEUE_H
#define __GKI_QUEUE_H

//------------------------------------------------------------------------------
// Queue Structure
//------------------------------------------------------------------------------
typedef struct {
    uint32_t Size;          // Size of unit queue, unit: PCS
    uint32_t Head;          // unit Index head pointer, unit: PCS
    uint32_t Tail;          // unit Index tail pointer, unit: PCS
    uint32_t Count;         // Number of units in queue, unit: PCS
    uint32_t DataSize;      // Either 2 or 4
    void  *pBuf;            // Pointer to queue buffer
} tQUEUE;


//------------------------------------------------------------------------------
// Sample queue prototypes
//------------------------------------------------------------------------------
void        GKI_QInit(tQUEUE *q, void *pBuf, uint32_t DataSize, uint32_t Size);
void        GKI_QGet(tQUEUE *q, void *data);
void        GKI_QPut(tQUEUE *q, void *data);
void        GKI_QPutISR(tQUEUE *q, void *data);
uint32_t    GKI_QGetBuf(tQUEUE *q, void *pDestBuf, uint32_t destLength);
uint32_t    GKI_QPutBuf(tQUEUE *q, void *pSrcBuf, uint32_t srcLength);
uint32_t    GKI_QPeekBuf(tQUEUE *q, void *pDestBuf, uint32_t destLength);
void        GKI_QPeek(tQUEUE *q, void *data);
bool        GKI_QNotReady(tQUEUE *q);
uint32_t    GKI_QFreeSpace(tQUEUE *q);
uint32_t    GKI_QCount(tQUEUE *q);
void      * GKI_QDataAddr(tQUEUE *q);

#endif // __GKI_QUEUE_H

//------------------------------------------------------------------------------
// End of GKI_Queue.h

