/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_gpio.h
 * @brief    GKI structures and prototypes for GPIO.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_GPIO_H
#define __GKI_GPIO_H

#include "ach118x_gpio.h"
//#include "ach118x_type.h"
#ifdef __cplusplus
    extern "C" {
#endif
typedef enum{
    Port_0=0,
    Port_1,
    Port_2,
    Port_3,
    Port_4,
    Port_5,
    Port_6,
    Port_7,
    Port_8,
    Port_9,
    Port_10,
    Port_11,
    Port_End
}PortType;
void GKI_GPIO_PortSetMode(uint8_t PinNo, uint8_t mode);
void GKI_GPIO_PortSet(uint8_t PinNum);
void GKI_GPIO_PortReset(uint8_t PinNum);
FlagStatus GKI_GPIO_PortRead(uint8_t PortNo);


#ifdef __cplusplus
    }//extern "C"
#endif

#endif // __GKI_GPIO_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

