/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_flash.h
 * @brief    GKI header for FLASH.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_FLASH_H
#define __GKI_FLASH_H

#include "flash.h"

void GKI_FlashInit(void);
void GKI_FlashReadID(uint8_t *pBuf);
void GKI_FlashSectorErase(uint32_t addr);
void GKI_FlashErase(uint32_t addr, uint32_t len);
void GKI_FlashWrite(uint32_t addr, uint8_t *pBuf, uint32_t len);
void GKI_FlashRead(uint32_t addr, uint8_t *pBuf, uint32_t len);


#endif // __GKI_FLASH_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

