/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_exti.h
 * @brief    GKI structures and prototypes for EXTI.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_EXTI_H
#define __GKI_EXTI_H

#include "ach118x_exti.h"


void GKI_ExtiInit(void);
void GKI_ExtiTestEnd(void);
FlagStatus GKI_ExtiGetITFlag(ExtiPin pin);
void GKI_ExtiClearITFlag(ExtiPin pin);

void GKI_ExtiPinInit(ExtiPin pin);
void GKI_ExtiISR_Register(void (*pfun)(void));
void GKI_WakeUpISR_Register(void (*pfun)(void));
void GKI_WakeUpInit(ExtiPin pin);
void GKI_ACC1340_ExtiInit(ExtiPin pin);

#endif//end __GKI_EXTI_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

