/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_dma.h
 * @brief    GKI structures and prototypes for DMA.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_DMA_H
#define __GKI_DMA_H

extern uint32_t UART_RX_DMA_Stream[];
extern uint32_t UART_TX_DMA_Stream[];

typedef struct {
    uint8_t *pData;
    uint16_t SendLength;
    uint16_t TotalLength;
} tHciDmaRec;
extern tHciDmaRec HciDmaRec;


typedef struct {
    void *pNext;
    uint16_t  Length;
    uint8_t   pData[];
} tLinkTxBuff;
extern tLinkTxBuff *pTxDmaInProgress;

// prototypes
uint16_t  GKI_dma_GetTxDataCounter(uint16_t u);
uint16_t  GKI_dma_GetRxDataCounter(uint16_t u);
uint16_t  GKI_dma_GetAvdtpDataCounter(void);
void GKI_dma_UartConfig(uint16_t);
void GKI_dma_Tx(uint16_t u, void *pData, uint16_t Length);
void GKI_dma_TxDirectly(tLinkTxBuff *pTxBuff);
void GKI_dma_TxStart(uint16_t u, void *pData, uint16_t Length);
void GKI_dma_TxCompleteIsr(uint16_t u, uint32_t BuffAddr);
void GKI_hci_startup(void);

#define UartDev     UART[u]             // Uart Base Address
#define MainUartDev UART[GKI_MainUart]  // Uart Base Address
#define pUart       (&TM_UartDev[u])    // Uart Structure
#define RX          (pUart->Rx)
#define TX          (pUart->Tx)
#define UartPin     (pUart->Pin)


#include "ach118x_map.h"
#include "ach118x_dma.h"


extern void DmaStart(int chn);

void GKI_DMAChannelCmd(DMA_Channel Channel_Num, FunctionalState NewState);
void GKI_DMATestSingleBlockTransgerInit(DMA_Channel_Typedef *Channel);
void GKI_MultiBlkTransferTestInit(DMA_Channel_Typedef *Channel);

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/

