/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_cp.h
 * @brief    GKI header used with co-processor (cp).
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef _GKI_CP_H
#define _GKI_CP_H

#include "ach118x_type.h"
#include "ach118x_i2c.h"
#include "coprocessor.h"
#include "GKI_wm8904.h"//This head file include the I2C registers.

#ifdef __cplusplus
    extern "C" {
#endif

//APIs
void GKI_I2cInitForCp(void);
void GKI_I2cKeepTxData(uint8_t slvAddr, uint8_t addr, uint8_t* data, uint32_t payload);
void GKI_I2cKeepRxData(uint8_t slvAddr, uint8_t addr, uint8_t* data, uint32_t payload);

#ifdef __cplusplus
    }//extern "C"
#endif

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/

