/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_codec.h
 * @brief    GKI prototypes for CODEC.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_CODEC_H
#define __GKI_CODEC_H

#include <stdint.h>
#include "ach118x_sys.h"
#include "ach118x_i2s.h"
#include "ach118x_codec.h"

#ifdef __cplusplus
    extern "C" {
#endif
#define     NS_SAMPLE_RATE      8000
void i2s1Rxstart(void);
void i2s1RxStop(void);
void i2s1Txstart(void);
void i2s1TxStop(void);
#define ASR_CODEC_WRRD_REG(Reg,Val)     do{\
                                            codec_reg_write_byte(Reg, Val);\
                                            if(codec_reg_read_byte(Reg) != Val) printf("codec reg%d write err!\r\n",Reg);\
                                            }while(0);
void GKI_CodecInit(uint32_t sampleRate);

void GKI_CodecGetLeft(int16_t *pBuf,unsigned short len);

void GKI_CodecPutLeft(int16_t *pBuf,unsigned short len);

void GKI_CodecGetRight(int16_t *pBuf,unsigned short len);

void GKI_CodecPutRight(int16_t *pBuf,unsigned short len);

char GKI_CodecRxDataReady(void);

char GKI_CodecTxDataEmpty(void);

void GKI_CodecTxStart(void);

void GKI_CodecRxStart(void);

void GKI_CodecTxStop(void);

void GKI_CodecRxStop(void);

#ifdef __cplusplus
    }//extern "C"
#endif

#endif // __GKI_CODEC_H

/******************************** (C) COPYRIGHT ART ****END OF FILE****/

