/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_aes.h
 * @brief    GKI prototypes for Advanced Encryption Standard (AES).
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef _GKI_AES_H
#define _GKI_AES_H

#include "ach118x_aes.h"

void GKI_AesEncryptionInit(void);
void GKI_AesEncryptionTest(void);
void GKI_AesReadCipher(uint32_t *pBuf);
void GKI_AesDecryptionInit(void);
void GKI_AesDecryptionTest(void);
void GKI_AesReadPlain(uint32_t *pBuf);
void GKI_AesTestEnd(void);

#endif // _GKI_AES_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

