/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_adc.h
 * @brief    GKI prototypes for ADC.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_ADC_H
#define __GKI_ADC_H

#include "ach118x_adc.h"

//------------------------------------------------------------------
// API prototypes
//------------------------------------------------------------------
void        GKI_AdcInit(ADC_Typedef* ADCx);
void        GKI_AdcStartConversion(ADC_Typedef* ADCx);
FlagStatus  GKI_AdcGetConversionStatus(ADC_Typedef* ADCx);
uint16_t    GKI_AdcGetConversionResult(ADC_Typedef* ADCx);
void        GKI_AdcITCmd(ADC_Typedef* ADCx, FunctionalState status);
FlagStatus  GKI_AdcGetITFlag(ADC_Typedef* ADCx);
void        GKI_AdcClearITFlag(ADC_Typedef* ADCx);
void        GKI_AdcPowerCmd(ADC_Typedef* ADCx, PowerCmd status);
void        GKI_AdcDisable(ADC_Typedef* ADCx);

#endif // __GKI_ADC_H

/************************ (C) COPYRIGHT ART *****END OF FILE****/

