/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_i2s.h
 * @brief    GKI functions and prototypes for I2S.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef _GKI_I2S_H
#define _GKI_I2S_H

#include "ach118x_i2s.h"

#ifdef __cplusplus
    extern "C" {
#endif

//I2S FIFO opertions.
#define I2S_FIFO_DEPTH     (16)    //The FIFO depth.
#define I2S_FIFO_THD       (8)     //TXFE IDLE space and RXDA fill space.

//APIs.
#if 0
void GKI_I2sInitForMaster(I2S_TypeDef* I2Sx);
void GKI_I2sCmd(I2S_TypeDef* I2Sx, FunctionalState NewState);
void GKI_I2sWrWordToLtFifo(I2S_TypeDef* I2Sx, uint16_t word);
void GKI_I2sWrWordToRtFifo(I2S_TypeDef* I2Sx, uint16_t word);
uint16_t GKI_I2sRdWordFromLrFifo(I2S_TypeDef* I2Sx);
uint16_t GKI_I2sRdWordFromRrFifo(I2S_TypeDef* I2Sx);
void GKI_I2sClrTxFifo(I2S_TypeDef* I2Sx);
void GKI_I2sClrRxFifo(I2S_TypeDef* I2Sx);
ITStatus GKI_I2sGetITStatus(I2S_TypeDef* I2Sx, uint8_t I2S_IT);
void GKI_I2sMaskIT(I2S_TypeDef* I2Sx, uint8_t I2S_IT, FunctionalState NewState);
FlagStatus GKI_I2sRdClrTxOverrunIntStatus(I2S_TypeDef* I2Sx);
FlagStatus GKI_I2sRdClrRxOverrunIntStatus(I2S_TypeDef* I2Sx);
//Callbacks.
#if defined(AVS) || defined(DUER)
void GKI_I2sRxdaRecCallBack(void *info);
void GKI_I2sRxdaRecPlaySyncCallBack(void *info);
void GKI_I2sTxfeRecPlaySyncCallBack(void *info);
#endif  //endif defined(AVS || DUER)
#if defined(AVS) || defined(DUER) || defined(MP3_DEMO) || defined(RADIO_DECODER)
void GKI_I2sTxfeMp3CallBack(void *info);
#endif  //endif defined(AVS || DUER || RADIO_DECODER)
#if defined(RADIO_DECODER)
void GKI_I2sTxfeMp4CallBack(void *info);
#endif  //endif defined(RADIO_DECODER)
#if defined(WCT)
void GKI_I2sRxdaWctCallBack(void *info);
void GKI_I2sTxfeWctCallBack(void *info);
#endif  //endif defined(WCT)

#if defined(WUW)
void GKI_I2sRxdaWuwCallback(void *info);
void GKI_I2sTxfeWuwCallBack(void *info);
#endif

#if defined(PICO)
void GKI_I2sRxdaPicoCallback(void *info);
void GKI_I2sTxfePicoCallBack(void *info);
#endif

#ifdef __cplusplus
    }//extern "C"
#endif
#endif
#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/

