/***************************************************************************************************
 *                               Generic Kernel Interface
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     GKI_DataTypes.h
 * @brief    GKI header used with common data types.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __GKI_DATA_TYPES_H_
#define __GKI_DATA_TYPES_H_

#include "ach118x_type.h"
#include <stdint.h>
#include <yvals.h>
#include "ach118x_device.h"
#include "ach118x_map.h"
#include "ach118x_file.h"
#ifndef true
    #define true   ((bool)(1))
#endif

#ifndef false
    #define false  ((bool)(0))
#endif

#ifndef NULL
    #define NULL   (0)
#endif

/*
#ifndef bool
    #define bool BOOL
#endif

#ifndef Boolean
    #define Boolean BOOL
#endif
*/

typedef signed char         sint8;
typedef signed short int    sint16;
typedef signed long         sint32;
typedef signed long long    sint64;
typedef char                shortbool;
#define zero64              ((uint64)0)

typedef unsigned char       UINT8;
typedef unsigned short      UINT16;
typedef unsigned long       UINT32;
typedef signed   long       INT32;
typedef signed   char       INT8;
typedef signed   short      INT16;
typedef unsigned char       BOOLEAN;

#if 0
typedef int64_t  s64;
typedef int32_t  s32;
typedef int16_t  s16;
typedef int8_t   s8;
#endif

#endif // __GKI_DATA_TYPES_H_

// End of BasicTypes.h

