#include "lwip/arch.h"
#include "lwip/ip.h"

#define MQTT_Q_CNT 10

#define MQTT_TASK_STACK_DEPTH    ( 2048 )
#define MQTT_TASK_PRIORITY       ( tskIDLE_PRIORITY + 7)//2 )

/**
 * @brief Type of the message sent from an application task to the MQTT task.
 */
typedef enum
{
    eMQTTConnectRequest = 0,     /**< Initiate a connection to an MQTT broker. */
    eMQTTDisconnectRequest,      /**< Disconnect the connection to an MQTT broker. */
    eMQTTSubscribeRequest,   /**< Initiate a subscribe to a topic.  _TODO_ Currently limited to one topic per subscribe message. */
    eMQTTUnsubscribeRequest, /**< Initiate unsubscribe from a topic.  _TODO_ Currently limited to one topic per unsubscribe message. */
    eMQTTPublishRequest,         /**< Initiate a publish to a topic.  _TODO_ Currently limited to one topic per publish message. */
    eMQTTSendAppendRequest
} MQTTAction_t;
/**
 * @brief Contents of the message sent from an application task to the MQTT task to
 * initiate an MQTT operation.
 *
 * Application task creates an object of this type and posts it to the command queue
 * in order to initiate an MQTT operation.
 */
typedef struct MQTTEventData
{
    MQTTAction_t xEventType;
    u8_t *topic;
    u8_t *msg;
    u16_t msg_len;
} MQTTEventData_t;

BaseType_t MQTT_Connect(void);
BaseType_t MQTT_Disconnect(void);
BaseType_t MQTT_Publish(const u8_t *topic, const u8_t *msg, uint16_t len);
BaseType_t MQTT_UnSub(const u8_t *topic, uint16_t mode);
void MQTTCmdTask( void * pvParameters );
void putConfigIP2Var(uint16_t CONFIG_ID, uint8_t ip_type, ip_addr_t *dst_var);
void set_dns_servers(const ip_addr_t *v4, const ip_addr_t *v6);